% UTAudioFreqDomainAnalysis.m

% Read the contents of the audio file
waveFilename = 'shortAudioClip.wav';
[myRecording, fs] = audioread(waveFilename);

% Plot the magnitude of the frequency content
% using a discrete-time version of the Fourier series
% Zoom the frequency axis to [-1500 Hz, 1500 Hz]
% to focus on the strongest frequency components
fourierSeriesCoeffs = fft(myRecording);
N = length(myRecording);
freqResolution = fs / N;
ff = (-fs/2) : freqResolution : (fs/2)-freqResolution;
figure;
plot(ff, abs(fftshift(fourierSeriesCoeffs)));
xlabel('f');
xlim( [-1500, 1500] );
 
% Plot the spectrogram
figure;
blockSize = round(N/4);
overlap = round(0.875 * blockSize);
spectrogram(myRecording, blockSize, overlap, blockSize, fs, 'yaxis');
