% UTAudioRecordAndPlayback.m

% Record from the microphone
fs = 8000;
numBits = 16;
numChannels = 1;
recordingTime = 1;
recObj = audiorecorder(fs, numBits, numChannels);
disp('Start recording...');
recordblocking(recObj, recordingTime);
disp('End recording.');
 
% Store data in double-precision floating-point array
myRecording = getaudiodata(recObj);
 
% Play back the recording with automatic scaling
soundsc(myRecording, fs);

% Remove DC value and normalize amplitude to [-1, 1]
myRecording = myRecording - mean(myRecording);
myRecording = myRecording / max(abs(myRecording));
 
% Save the data to a file
waveFilename = 'shortAudioClip.wav';
audiowrite(waveFilename, myRecording, fs );
