% UTAudioTimeDomainAnalysis.m

% Read the contents of the audio file
waveFilename = 'shortAudioClip.wav';
[myRecording, fs] = audioread(waveFilename);
 
% Play back the recording with automatic scaling
soundsc(myRecording, fs);

% Plot the waveform in the time domain
N = length(myRecording);
Ts = 1/fs;
t = 0 : Ts : (N-1)*Ts;
figure;
plot(t, myRecording);
xlabel('t');
