function s = dchirp( TW, p )
% DCHIRP   generate a sampled chirp signal
%   usage  s = dchirp( TW, p )
%          s : samples of a discrete-time "chirp" signal
%              exp(j pi (W/T) t^2 )   for -T/2 <= t <= T/2
%          TW : time-bandwidth product
%          p : sample at p times the Nyquist rate (W)
N = p*TW;
alpha = TW / (2*N^2);
n = 0 : N-1;
s = exp(j*2*pi*alpha*(n - N/2).^2);
