function [ftValues, freqs] = utplotspec(x, Ts)
%   UTPLOTSPEC  plot the magnitude and phase of the Fourier
%               transform vs. frequency in Hz and return
%               the frequency-domain samples computed and
%               their corresponding frequency values
%            
%   usage  [ftValues, freqs] = utplotspec(x, Ts)
%          ftValues : Fourier transform values
%          freqs : frequencies in Hz corresponding to spectrum vector
%          x : discrete-time signal as a vector of samples
%          Ts : time (in seconds) between adjacent samples in x

% Based on plotspec(x, Ts) from Software Receiver Design
% by R. Johnson, W. Sethares and A. Klein

N = length(x);                     % length of the signal x
freqResolution = 1/(N*Ts);         % frequency resolution fs/N

fx = fft(x);                       % compute DFT/FFT
fxs = fftshift(fx);                % shift it for plotting

if floor(N/2) == N/2               % even
    kstart = -N/2;
    kend = (N/2) - 1;
else                               % odd
    kstart = -(N-1)/2;
    kend = (N-1)/2;
end
kshift = kstart : kend;            % FFT indices for fftshift
freqs = kshift * freqResolution;  % frequency vector

subplot(2,1,1), plot(freqs, abs(fxs));    % plot mag spectrum
xlabel('frequency (Hz)');                 % label axes
ylabel('magnitude (linear units)');    
subplot(2,1,2), plot(freqs, unwrap(angle(fxs)));  % plot phase spectrum
xlabel('frequency (Hz)');                 % label axes
ylabel('phase (rad)');

ftValues = fxs;
