%%% Bandstop filter from Nov. 11, 2021, lecture

%%% Zero out discrete-time freq. pi/2 and -pi/2
%%% Stopbands centered at these frequencies.
%%% Numerator is (1 - z0 z^(-1))(1 - z1 z^(-1))
%%% which is 1 - (z0 + z1) z^(-1) + z0 z1 z^(-2)
zeroAngle = pi/2;
z0 = exp(j*zeroAngle);
z1 = exp(-j*zeroAngle);

b0 = 1;
b1 = -(z0+z1);
b2 = z0*z1;
numerCoeffs = [b0 b1 b2];

%%% Poles at discrete-time freq. 0 and pi.
%%% Passbands centered at these frequencies.
%%% Denominator is (1 - p0 z^(-1))(1 - p1 z^(-1))
%%% which is 1 - (p0 + p1) z^(-1) + p0 p1 z^(-2)
p0 = 0.9;
p1 = -0.9;

a0 = 1;
a1 = -(p0+p1);
a2 = p0*p1;
denomCoeffs = [a0 a1 a2];

%%% Gain for the filter
C = 1;

%%% Plot the magnitude response
w = -pi : (2*pi/10000) : pi;
Hnumer = (b0 + b1*exp(-j*w) + b2*exp(-j*2*w));
Hdenom = (a0 + a1*exp(-j*w) + a2*exp(-j*2*w));
H = C * Hnumer ./ Hdenom;
plot(w, abs(H));
xlim( [-pi pi] );
xlabel('w [rad/sample]');
ylabel('Magnitude Response');
