w0hat = 2*pi*3/20;
Nperiods = 10000;
% (a) Discrete-time period
ctperiods = 3;
dtperiod = 20;
% (b) Impulse lasting 3 periods
numSamples = Nperiods*dtperiod;
impulse = zeros(1, numSamples);
impulse(1) = 1;
% (c) Generate impulse response
b = [0 sin(w0hat)];
a = [1 -2*cos(w0hat) 1];
h = filter(b, a, impulse);
% (d) Plot impulse response
n = 0 : numSamples - 1;
nmax = 3*dtperiod;
figure;
stem(n(1:nmax), h(1:nmax));
% (e) Plot frequency content
% of the impulse response
figure;
freqz(h);
% (f) Plot poles and zeros
figure;
zplane(b, a);
