%% Code to plot the frequency response
%% H(jw) = 1 - exp(-j2w)
%% for w in [-10, 10] rad/s
w = -10 : 0.01 : 10;
H = 1 - exp(-j*2*w);
figure;
plot(w, abs(H));
figure;
plot(w, phase(H));
%% Magnitude response does not fit neatly into
%% the categories of lowpass, highpass, bandpass,
%% bandstop, allpass, or notch.
%% The magnitude response has multiple passbands
%% and regularly spaced notches.
%% Frequencies that are integer multiples of
%% pi rad/s are notched out, including 0 rad/s.
%%
%% For H(jw) = 1 - exp(-j2w),
%% h(t) = d(t) - d(t-2)
%% where d(t) is the Dirac delta.
%% This is a continuous-time echo effect filter
%% that is similar to the discrete-time echo
%% effect filter in mini-project #2.
%%
%% The regularly spaced notches in the magnitude
%% response give rise to the name of a comb
%% filter (as in a hair comb).
%%
%% https://en.wikipedia.org/wiki/Comb_filter 
%%
%% The specific discussion of a continuous-time
%% comb filter is available at
%%
%% https://en.wikipedia.org/wiki/Comb_filter#Continuous-time_comb_filters
