% (a) Define interval of time
Ts = 0.001;
t = 0 : Ts : 5;
% (b) Define rectangular pulse
x1 = rectpuls(t-0.5);
% (c) Plot rectangular pulse
figure;
plot(t, x1);
ylim( [-1.2, 1.2] );
% (d) Convolve x1 with itself
y1 = conv(x1, x1);
y1 = y1(1:length(t));
% (e) Plot y1
figure;
plot(t, y1);
% Result is causal triangle that
% lasts for 2 seconds, which is
% sum of durations of x1 and x1
% (f) Define pulse for 0 to 2s
x2 = rectpuls((t-1)/2);
% (g) Plot x2
figure;
plot(t, x2);
ylim( [-1.2, 1.2] );
% (h) Convolve x1 and x2
y2 = conv(x1, x2);
y2 = y2(1:length(t));
% (i) Plot y2
figure;
plot(t, y2);
ylim( [-1, 1100] );
% Result: causal trapezoid that
% lasts for 3 seconds, which is
% sum of durations of x1 and x2
