% Tune-Up #7

% Copy this file into a Matlab script window, add your code
% and answers to the questions as Matlab comments, hit "Publish",
% and upload the resulting PDF file to this page for the tune-up
% assignment.  Please do not submit a link to a file but instead
% upload the file itself.  Late penalty: 2 points per minute late.

% This tuneup is to help you get started on the mini project #2.

% NOTE: imshow(image) will display the image by clipping the pixel
% values outside a certain range.  The range depends on the data
% type of the image.  In our case, the image is double and the
% range is [0, 1] where 0 corresponds to black and 1 to white.

% (a) Load the image.  Download the image from 
% https://users.ece.utexas.edu/~bevans/courses/signals/homework/echar512.matLinks to an external site.
% and place it in the current directory or a directory on the Matlab path.

load echar512.mat

% The load command will define a Matlab matrix echart.

% (b) Display the image. 

figure;
imshow(echart, [0 255]);

% Describe the image.
% --> Image has six rows of the same text
% E W S X M P E W S X M P 
% with the font size (different resolutions)
% getting smaller from top to bottom.

% (c) Interrogate the values in the image by clicking on the
%      Matlab variable in the workspace.

%      What values are in the image?
%      --> 0 for black and 255 for white.  It's a binary image.

%      To what grayscale intensities do they correspond?
%      --> 0 for black and 255 for white.  It's a binary image.

% (d) Apply a two-point averaging filter along the rows.
%      Display the resulting image.

%      Describe the result image compared to the original.
%      --> When the two-point averaging filter passes across a
%      one-pixel wide line, the input image would have pixel
%      values 255 255 0 255 255 and the output values for 
%      the middle three pixel values would be 510 255 255,
%      which is white mid-gray mid-gray, respectively, when
%      displayed using a range of [0, 510].  The one pixel-wide
%      line in the input image has been smoothed out (widened
%      and made mid-gray) which might not be visible.
%      --> When the two-point averaging filter passes across a
%      two-pixel wide line, the input image would have pixel
%      values 255 255 0 0 255 255 and the output values for 
%      the middle four pixel values would be 510 255 0 255,
%      which is white mid-gray black mid-gray, respectively,
%      when displayed using a range of [0, 510].
%      The two pixel-wide line in the input image has been
%      smoothed out (widened to three pixels) and appears to
%      be a thinner one-pixel black line.

FIRcoefficients1 = [1 1];
echartFilteredAlongRows1 = filter(FIRcoefficients1, 1, echart, [], 2);
figure;
imshow(echartFilteredAlongRows1, [0 510]);

% (e) Apply a three-point averaging filter along the rows.
%      Display the resulting image.

%      Describe the result image compared to the original.
%      --> When the three-point averaging filter passes across
%          a one-pixel wide line, the input image would have
%          pixel values 255 255 255 255 0 255 255 255 255 and
%          the output values for the middle five pixel values
%          would be 765 765 510 510,
%          which is white white light-gray light-gray, respectively,
%          when displayed using a range of [0, 765].
%          The one pixel-wide black line in the input image has been
%          widened and made light-gray (appears white).

FIRcoefficients2 = [1 1 1];
echartFilteredAlongRows2 = filter(FIRcoefficients2, 1, echart, [], 2);
figure;
imshow(echartFilteredAlongRows2, [0 765]);