% Tuneup #7

% Please see the Designing Averaging Filters handout.

% Compare two-point and seven-point averaging filters.

% Here are their impulse responses:
h2 = (1/2) * [ 1 1 ];
h7= (1/7) * [ 1 1 1 1 1 1 1 ];

% (a) Plot their impulse responses 
n = -1 : 8;
h2padded = [ 0 h2 0 0 0 0 0 0 0 ];
figure;
stem(n, h2padded);
ylim( [-0.2 0.6 ] );
xlabel('n');
title('Impulse response');
hold on;
h7padded = [ 0 h7 0 0 ];
stem(n, h7padded);
hold off;

% Commonalities and differences in impulse responses:
%   Commonalities -- both are rectangular pulses
%   Differences -- Lengths 2 and 7, respectively.

% Compute the frequency responses used in parts (b) and (c)
w = -pi : 0.001 : pi;
[Hfreq2, w] = freqz(h2, 1, w);
[Hfreq7, w] = freqz(h7, 1, w);

% (b) Plot their magnitude responses
figure;
hold on;
plot(w, abs(Hfreq2));
xlabel('w');
ylabel('Linear units');
title('Magnitude response');
plot(w, abs(Hfreq7));
hold off;

% Commonalities and differences in magnitude responses:
%   Commonalities -- both are lowpass filters
%   Differences --
%     two-point filter eliminates 1 frequency (pi rad/sample)
%     seven-point filter eliminates 6 frequencies
%       (-6pi/7, -4pi/7, -2pi/7, 2pi/7, 4pi/7, 6pi/7 rad/sample)
%     seven-point filter has a much more narrow passband

% (c) Plot their phase responses. 
figure;
hold on;
plot(w, phase(Hfreq2));
xlabel('w');
ylabel('Radians');
title('Phase response');
plot(w, phase(Hfreq7));
hold off;

% Compute the delay through each filter by using the phase response.
% Group delay is the negative of derivative of phase w/r to w
% Group delay is 1/2 sample and 3 samples, respectively
% Group delay for an N-point averaging filter is (N-1)/2

% Commonalities and differences in phase responses:
%   Commonalities -- phase responses are linear except for
%     phase discontinuites at the frequencies that are 
%     eliminated by the filter (which means that the phase
%     discontinuities can be ignored)
%   Differences -- slopes are -1/2 and -3

