% Tune-Up #3

% Copy this file into a Matlab script window, add your code and answers to the
% questions as Matlab comments, hit "Publish", and upload the resulting PDF file
% to this page for the tune-up assignment.  Please do not submit a link to a file
% but instead upload the file itself.   Late penalty: 2 points per minute late.

% Shepard Scale Demo
% https://www.illusionsindex.org/i/shepard-scale-illusionsLinks to an external site. 

% Part A.  We will answer the question in Section 2 of mini-project #1 on
% Shepard Scale Synthesis.
% https://users.ece.utexas.edu/~bevans/courses/signals/homework/fall2024/miniproject1.pdf

% Part B. We will answer the questions in Section 3.1 of mini-project #1 on
% Shepard Scale Synthesis.
% https://dspfirst.gatech.edu/chapters/DSP1st2eLabs/ShepardScaleLab.pdf

% Please place the code for the FrequencyWeighting function
% into a file FrequencyWeighting.m and then comment out the
% code in your Matlab script.
% function output = FrequencyWeighting(fc,sig,ff)
% output = exp(-(log2(ff) - log2(fc) ).^2/(2*sig^2));
%%output = exp(-(ff - fc ).^2/(2*sig^2));
% end

% Solution by Elyes Balti (TA) for ECE 313 Evans.

clear all
clc
close all

%% Prelab

%% 2 Generate the gaussian wave
v = -10:.01:10;
alph = 10;
mu = 1;
sig = 3;
gausswave = alph*exp(-(v-mu).^2/(2*sig^2));

figure
plot(v,gausswave,'linewidth',2);
xlabel('v')
ylabel('Probability Density Function')
title('Gaussian Distribution')
grid on

%% 3 Warm-up

%3.1 Gaussian Weighting
%b 
ff = 2.^(5:1/12:10);

%c 
fc = 440;
wd = (1760 - 55)/6;
sig = 1;
frequencies = 55:1/12:1760;
weights = FrequencyWeighting(fc,sig,frequencies);

%Plot using the semilogx command (log scale)
figure;
semilogx(frequencies, weights, 'b-', 'LineWidth', 1.5); % Plot with logarithmic x-axis
xlabel('Frequency (Hz)'); % Label for x-axis
ylabel('Weight'); % Label for y-axis
title('Gaussian Weighting Function Centered at 440 Hz with One Octave Width'); % Title of the plot
grid on; % Turn on the grid for better visualization
hold on;
xline(fc, 'r--', 'LineWidth', 1.5, 'Label', 'Center Frequency (440 Hz)', 'LabelHorizontalAlignment', 'right'); % Vertical line at center frequency
hold off;

%d
% Plot using the plot command (linear scale)
figure;
plot(frequencies, weights, 'b-', 'LineWidth', 1.5); % Plot with linear x-axis
xlabel('Frequency (Hz)'); % Label for x-axis
ylabel('Weight'); % Label for y-axis
title('Gaussian Weighting Function vs Frequency (Linear Scale)');
grid on;

% Explanation: 
% The Gaussian appears distorted because the plot command uses a linear scale 
% for frequency. Since the Gaussian function is defined on the log scale (log2(f)), 
% the bell shape is compressed towards the center frequency when plotted on a 
% linear frequency axis, causing distortion.
% When using semilogx, the x-axis is logarithmic (base 2), which aligns with the 
% Gaussian function's definition in terms of log2(f). This restores the expected 
% bell shape because the x-axis correctly represents the frequency spacing as intended 
% by the Gaussian distribution in log-frequency space.

