clear all
clc
close all

%% Prelab

%% 2 Generate the gaussian wave
v = -10:.1:10;
alph = 10;
mu = 1;
sig = 3;
gausswave = alph*exp(-(v-mu).^2/(2*sig^2));

figure
plot(v,gausswave,'linewidth',2);
xlabel('v')
ylabel('Probability Density Function')
title('Gaussian Distribution')
grid on

%% 3 Warm-up

%3.1 Gaussian Weighting
%b 
ff = 2.^(5:1/12:10);

%c 
fc = 440;
wd = (1760 - 55)/6;
sig = 1;
frequencies = 55:1/12:1760;
weights = FrequencyWeighting(fc,sig,frequencies);

%Plot using the semilogx command (log scale)
figure;
semilogx(frequencies, weights, 'b-', 'LineWidth', 1.5); % Plot with logarithmic x-axis
xlabel('Frequency (Hz)'); % Label for x-axis
ylabel('Weight'); % Label for y-axis
title('Gaussian Weighting Function Centered at 440 Hz with One Octave Width'); % Title of the plot
grid on; % Turn on the grid for better visualization
hold on;
xline(fc, 'r--', 'LineWidth', 1.5, 'Label', 'Center Frequency (440 Hz)', 'LabelHorizontalAlignment', 'right'); % Vertical line at center frequency
hold off;

%d
% Plot using the plot command (linear scale)
figure;
plot(frequencies, weights, 'b-', 'LineWidth', 1.5); % Plot with linear x-axis
xlabel('Frequency (Hz)'); % Label for x-axis
ylabel('Weight'); % Label for y-axis
title('Gaussian Weighting Function vs Frequency (Linear Scale)');
grid on;

% Explanation: 
% The Gaussian appears distorted because the plot command uses a linear scale 
% for frequency. Since the Gaussian function is defined on the log scale (log2(f)), 
% the bell shape is compressed towards the center frequency when plotted on a 
% linear frequency axis, causing distortion.
% When using semilogx, the x-axis is logarithmic (base 2), which aligns with the 
% Gaussian function's definition in terms of log2(f). This restores the expected 
% bell shape because the x-axis correctly represents the frequency spacing as intended 
% by the Gaussian distribution in log-frequency space.


%%
%3.2 Synthesize Octaves with Gaussian Weighting
% Parameters
fs = 8000;        % Sampling frequency in Hz
duration = 2;     % Duration of the signal in seconds
t = 0:1/fs:duration-(1/fs);  % Time vector
fc = 440;         % Center frequency of the Gaussian at 440 Hz
sigma = 1;        % Width of one octave in log scale

% Key numbers for the notes: C2, C3, C4, C5, C6
% MIDI key numbers: C2 (16), C3 (28), C4 (40), C5 (52), C6 (64)
%keynums = [36, 48, 60, 72, 84];
keynums = [16, 28, 40, 52, 64];

% Frequencies corresponding to the key numbers for C2, C3, C4, C5, and C6
% Note that 49 is the keynum of A4 (the reference)
frequencies = 440 * 2.^((keynums - 49)/12);

% Calculate Gaussian weights for these frequencies
weights = FrequencyWeighting(fc,sigma,frequencies);

% Initialize the final signal
final_signal = zeros(size(t));

% Generate each note using key2note function and add with Gaussian weights
for i = 1:length(keynums)
    note = key2note(weights(i),keynums(i), duration, fs);  % Synthesizes the correct sinusoidal signal for the key number 
    final_signal = final_signal + note; % Weight the note by the Gaussian and sum
end

% Normalize the final signal to avoid clipping
final_signal = final_signal / max(abs(final_signal));

% Play the synthesized sound
sound(final_signal, fs);

% Optional: Save the sound to a file
audiowrite('Gaussian_Weighted_Octave_Sound.wav', final_signal, fs);


% Plot the spectrogram
window_length = 2048; % Long window length for good frequency resolution
overlap = window_length / 2; % 50% overlap
nfft = window_length; % Number of FFT points

figure; 
[S, F, T, P] =spectrogram(final_signal, window_length, overlap, nfft, fs, 'yaxis');
title('Spectrogram of Synthesized Sound');
imagesc(T, F, 10*log10(P)); % Use imagesc for better colormap handling
axis xy; % Correct the orientation of the y-axis
title('Spectrogram of Synthesized Sound');
xlabel('Time (s)');
ylabel('Frequency (Hz)');
ylim([0 1200]); % Limit frequency range to show relevant peaks
colorbar;
colorbar;

% Add lines for each frequency to identify peaks
hold on;
yline(frequencies(5), 'c--', 'LineWidth', 1.5, 'Label', ['C6 ' num2str(frequencies(5))], 'LabelHorizontalAlignment', 'left');
yline(frequencies(4), 'm--', 'LineWidth', 1.5, 'Label', ['C5 ' num2str(frequencies(4))], 'LabelHorizontalAlignment', 'left');
yline(frequencies(3), 'b--', 'LineWidth', 1.5, 'Label', ['C4 ' num2str(frequencies(3))], 'LabelHorizontalAlignment', 'left');
yline(frequencies(2), 'g--', 'LineWidth', 1.5, 'Label', ['C3 ' num2str(frequencies(2))], 'LabelHorizontalAlignment', 'left');
yline(frequencies(1), 'r--', 'LineWidth', 1.5, 'Label', ['C2 ' num2str(frequencies(1))], 'LabelHorizontalAlignment', 'left');
hold off;

%% 4 Lab: A Musical Illusion

%% a
% Parameters
fs = 22050;        % Sampling frequency in Hz
duration = 1;      % Duration of each note in seconds
t = 0:1/fs:duration-1/fs;  % Time vector for each note


% MIDI key numbers for C-major scale starting at middle-C (C4)
% C4 (40), D4 (42), E4 (44), F4 (45), G4 (47), A4 (49), B4 (51), C5 (52)
keynums = [40, 42, 44, 45, 47, 49, 51, 52];

final_signal = [];
for key=keynums

freq = 440 * 2.^((key - 49)/12);
octaves = GenerateFrequency(freq);

note_signal = zeros(size(freq));
for f = octaves
    % ignore all the weithing amplitudes as stated in part a)
 note_signal = note_signal + cos(2*pi*f*t);
end

note_signal = note_signal/max(abs(note_signal));

final_signal = [final_signal note_signal];
end
final_signal = final_signal / max(abs(final_signal));

sound(final_signal,fs)
% Optional: Save the sound to a file
audiowrite('C_Major_Scale_With_Octaves.wav', final_signal, fs);

%% b 

% Parameters
fs = 22050;        % Sampling frequency in Hz
note_duration = 0.5;   % Duration of each note in seconds
silence_duration = 0.2; % Duration of silence between notes in seconds
t_note = 0:1/fs:note_duration-1/fs;  % Time vector for each note
t_silence = zeros(1, round(silence_duration * fs));  % Silence vector

% MIDI key numbers for C-major scale starting at middle-C (C4)
% C4 (40), D4 (42), E4 (44), F4 (45), G4 (47), A4 (49), B4 (51), C5 (52)
keynums = [40, 42, 44, 45, 47, 49, 51, 52];

% Function to generate frequencies for each key, including octaves
generate_frequencies = @(freq) freq * 2.^(-4:4); % Generate frequencies for 4 octaves below and above

% Initialize the final signal to empty
final_signal = [];

% Repeat the C-major scale five times
for repetition = 1:5
    % Loop through each key number in the C-major scale
    for key = keynums
        % Calculate the frequency for the current key
        freq = 440 * 2^((key - 49) / 12); % Calculate frequency from MIDI key number (49 is A4, 440 Hz)

        % Generate the frequencies including 4 octaves below and above
        octaves = GenerateFrequency(freq);

        % Initialize note signal with zeros
        note_signal = zeros(1, length(t_note));

        % Sum sinusoids for each frequency
        for f = octaves
            note_signal = note_signal + cos(2 * pi * f * t_note);
        end

        % Normalize note signal to prevent excessive amplitude
        note_signal = note_signal / max(abs(note_signal));

        % Append the note signal and silence to the final signal
        final_signal = [final_signal, note_signal, t_silence];
    end
end

% Normalize the final signal to avoid clipping
final_signal = final_signal / max(abs(final_signal));

% Play the synthesized C-major scale
sound(final_signal, fs);

% Optional: Save the sound to a file
audiowrite('C_Major_Scale_With_Octaves_Repeated.wav', final_signal, fs);

%% c

% Parameters for the Gaussian weighting
fc = 380;       % Center frequency between 260 and 500 Hz
sigma = 2;      % Standard deviation in log2(f) scale

% Frequency range for plotting
f = linspace(20, 2000, 1000);  % Frequencies from 20 Hz to 2000 Hz

% Calculate Gaussian weighting function as a function of log2(f)

W = FrequencyWeighting(fc,sigma,f);

% Plotting the weighting function versus log2(f)
figure;
plot(log2(f), W, 'LineWidth', 2);
xlabel('log_2(f)');
ylabel('Weighting Function W(f)');
title('Gaussian Weighting Function versus log_2(f)');
grid on;
xlim([log2(20), log2(2000)]);  % Set x-axis limits based on the frequency range

%% d
% Parameters
fs = 22050;               % Sampling frequency in Hz
note_duration = 0.5;      % Duration of each note in seconds
silence_duration = 0.2;   % Duration of silence between notes in seconds
t_note = 0:1/fs:note_duration-1/fs;  % Time vector for each note
t_silence = zeros(1, round(silence_duration * fs));  % Silence vector

% MIDI key numbers for C-major scale starting at middle-C (C4)
% C4 (40), D4 (42), E4 (44), F4 (45), G4 (47), A4 (49), B4 (51), C5 (52)
keynums = [40, 42, 44, 45, 47, 49, 51, 52];

% Gaussian weight function parameters
fc = 380;       % Center frequency between 260 and 500 Hz
sigma = 2;      % Standard deviation in log2(f) scale


% Initialize the final signal to empty
final_signal = [];

% Repeat the C-major scale five times
for repetition = 1:5
    % Loop through each key number in the C-major scale
    for key = keynums
        % Calculate the frequency for the current key
        freq = 440 * 2^((key - 49) / 12); % Calculate frequency from MIDI key number (49 is A4, 440 Hz)

        % Generate the frequencies including 4 octaves below and above
        octaves = GenerateFrequency(freq);

        % Initialize note signal with zeros
        note_signal = zeros(1, length(t_note));

        % Sum sinusoids for each frequency, weighted by the Gaussian function
        for f = octaves
            % Calculate the Gaussian weight for the current frequency
            weight = FrequencyWeighting(fc,sigma,f);
            
            % Add the weighted sinusoid to the note signal
            note_signal = note_signal + weight * cos(2 * pi * f * t_note);
        end

        % Normalize note signal to prevent excessive amplitude
        note_signal = note_signal / max(abs(note_signal));

        % Append the note signal and silence to the final signal
        final_signal = [final_signal, note_signal, t_silence];
    end
end

% Normalize the final signal to avoid clipping
final_signal = final_signal / max(abs(final_signal));

% Play the synthesized C-major scale with the illusion effect
sound(final_signal, fs);

% Optional: Save the sound to a file
audiowrite('C_Major_Scale_Illusion_With_Gaussian_Weighting.wav', final_signal, fs);


%% d
% Parameters
fs = 22050;               % Sampling frequency in Hz
note_duration = 0.5;      % Duration of each note in seconds
silence_duration = 0.2;   % Duration of silence between notes in seconds
t_note = 0:1/fs:note_duration-1/fs;  % Time vector for each note
t_silence = zeros(1, round(silence_duration * fs));  % Silence vector

% MIDI key numbers for C-major scale starting at middle-C (C4)
% C4 (40), D4 (42), E4 (44), F4 (45), G4 (47), A4 (49), B4 (51), C5 (52)
keynums = [40, 42, 44, 45, 47, 49, 51, 52];

% Gaussian weight function parameters
fc = 380;       % Center frequency between 260 and 500 Hz
sigma = 2;      % Standard deviation in log2(f) scale


% Initialize the final signal to empty
final_signal = [];

% Repeat the C-major scale three times for spectrogram analysis
for repetition = 1:3
    % Loop through each key number in the C-major scale
    for key = keynums
        % Calculate the frequency for the current key
        freq = 440 * 2^((key - 49) / 12); % Calculate frequency from MIDI key number (49 is A4, 440 Hz)

        % Generate the frequencies including 4 octaves below and above
        octaves = GenerateFrequency(freq);

        % Initialize note signal with zeros
        note_signal = zeros(1, length(t_note));

        % Sum sinusoids for each frequency, weighted by the Gaussian function
        for f = octaves
            % Calculate the Gaussian weight for the current frequency
            weight = FrequencyWeighting(fc,sigma,f);
            
            % Add the weighted sinusoid to the note signal
            note_signal = note_signal + weight * cos(2 * pi * f * t_note);
        end

        % Normalize note signal to prevent excessive amplitude
        note_signal = note_signal / max(abs(note_signal));

        % Append the note signal and silence to the final signal
        final_signal = [final_signal, note_signal, t_silence];
    end
end

% Normalize the final signal to avoid clipping
final_signal = final_signal / max(abs(final_signal));

% Play the synthesized C-major scale with the illusion effect
sound(final_signal, fs);

% Optional: Save the sound to a file
audiowrite('C_Major_Scale_Illusion_With_Gaussian_Weighting.wav', final_signal, fs);

% Generate the spectrogram using MATLAB's built-in function
figure;
spectrogram(final_signal, 1024, 512, 1024, fs, 'yaxis');
title('Spectrogram of C-Major Scale with Gaussian Weighted Illusion');
xlabel('Time (s)');
ylabel('Frequency (Hz)');
colorbar;

% Explanation
% Illusion of Continuous Rising or Descending: The spectrogram may show a "rising" or “falling” 
% illusion due to how the Gaussian weights emphasize certain frequencies across the octaves, 
% making it seem like the sound continuously ascends or descends without a clear start or end point.

% Visual Features: In the spectrogram, look for:
% Bands of Energy: Multiple octave-related bands that are emphasized and de-emphasized 
% cyclically.
% Smooth Transitions: Lack of clear separations between the end of one note and 
% the beginning of the next, contributing to the auditory illusion.

% By analyzing the spectrogram, you can visually understand how the Gaussian weighting contributes
% to the auditory illusion, making the scale sound like it's endlessly ascending or descending, 
% even though it repeats the same notes cyclically.

%% e
% Parameters
fs = 22050;               % Sampling frequency in Hz
note_duration = 0.5;      % Duration of each note in seconds
silence_duration = 0.1;   % Duration of silence between notes in seconds
t_note = 0:1/fs:note_duration-1/fs;  % Time vector for each note
t_silence = zeros(1, round(silence_duration * fs));  % Silence vector

% MIDI key numbers for all twelve semitones within an octave, starting at C4
% C4 (40) to B4 (51)
keynums = 40:51;  % Chromatic scale from C4 to B4

% Gaussian weight function parameters
fc = 380;       % Center frequency between 260 and 500 Hz
sigma = 2;      % Standard deviation in log2(f) scale


% Initialize the final signal to empty
final_signal = [];

% Repeat the chromatic scale sequence multiple times
repetitions = 5;  % Number of times to repeat the sequence

for repetition = 1:repetitions
    % Loop through each key number in the chromatic scale
    for key = keynums
        % Calculate the frequency for the current key
        freq = 440 * 2^((key - 49) / 12); % Calculate frequency from MIDI key number (49 is A4, 440 Hz)

        % Generate the frequencies including 4 octaves below and above
        octaves = GenerateFrequency(freq);

        % Initialize note signal with zeros
        note_signal = zeros(1, length(t_note));

        % Sum sinusoids for each frequency, weighted by the Gaussian function
        for f = octaves
            % Calculate the Gaussian weight for the current frequency
            weight = FrequencyWeighting(fc,sigma,f);
            
            % Add the weighted sinusoid to the note signal
            note_signal = note_signal + weight * cos(2 * pi * f * t_note);
        end

        % Normalize note signal to prevent excessive amplitude
        note_signal = note_signal / max(abs(note_signal));

        % Append the note signal and silence to the final signal
        final_signal = [final_signal, note_signal, t_silence];
    end
end

% Normalize the final signal to avoid clipping
final_signal = final_signal / max(abs(final_signal));

% Play the synthesized chromatic scale with the illusion effect
sound(final_signal, fs);

% Optional: Save the sound to a file
audiowrite('Chromatic_Scale_Illusion_With_Gaussian_Weighting.wav', final_signal, fs);

% Generate the spectrogram for analysis
figure;
spectrogram(final_signal, 1024, 512, 1024, fs, 'yaxis');
title('Spectrogram of Chromatic Scale with Gaussian Weighted Illusion');
xlabel('Time (s)');
ylabel('Frequency (Hz)');
colorbar;

%Explanation and Analysis:
%1. Chromatic Scale: The MIDI key numbers 60 to 71 correspond to all twelve semitones from C4 to B4,
%making up the full chromatic scale within one octave.
%2. Gaussian Weighting: The Gaussian weighting is applied to emphasize frequencies around 380 Hz, 
% with weights decreasing for frequencies further from the center on a logarithmic scale.
%3. Improved Illusion: Including all twelve notes creates a smoother, more continuous pitch progression, 
% which often enhances the illusion of an endlessly rising or falling scale. 
% This is because the listener perceives a continuous transition without the distinct intervals 
% of a major scale.
%4. Repetition: Repeating the chromatic scale multiple times strengthens the illusion and helps to
% maintain the perceptual effect.
%5. Spectrogram Analysis: The spectrogram will show overlapping bands of frequencies, 
% with energy smoothly transitioning across the notes, illustrating the continuous nature of 
% the Shepard tone illusion.

%% g
% Matlab code prepared !!






