% Copyright (c) 2003-2004 The University of Texas
% All Rights Reserved.
%  
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%  
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%  
% The GNU Public License is available in the file LICENSE, or you
% can write to the Free Software Foundation, Inc., 59 Temple Place -
% Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
% World Wide Web at http://www.fsf.org.
%  
% Programmers:	Zukang Shen
% 
% The authors are with the Department of Electrical and Computer
% Engineering, The University of Texas at Austin, Austin, TX.
% They can be reached at shen@ece.utexas.edu.



time1=clock
worstpower=1.1565;
N=64;
B=1000000;
N0=worstpower*1e-8;
Ptotal=1;
noise=B*N0/N;
epsilong=1e-3;
channelnum=5;
samplenum=1;
tdmaX=ones(1,N);
tdmap=Ptotal/N*ones(1,N);
pathdiffstep=10;


%for usernum=8
usernum=8;
gammaSetNum=8;
pathdiff=[pathdiffstep 1 1 1 1 1 1 1];
gammaSet=ones(gammaSetNum,usernum);
for i=1:gammaSetNum
    gammaSet(i,1)=2^(i-1);
end

%for usernum=16
% usernum=16;
% gammaSetNum=5;
% pathdiff=[ones(1,4)*pathdiffstep ones(1,12)];
% gammaSet=ones(gammaSetNum,usernum);
% for i=1:gammaSetNum
%     gammaSet(i,1:4)=2^(i-1)*ones(1,4);
% end

outage=zeros(1,gammaSetNum);
mycapaAccumulate=zeros(gammaSetNum,usernum);      
MaxCapaAccumulate=zeros(gammaSetNum,usernum);
tdmaCapaAccumulate=zeros(gammaSetNum,usernum);

%for different gamma sets
for ii=1:gammaSetNum

   

   totalsumtdma=0;
   totalmycapa=0;
   totalLeeCapa=0;
   totalLargerstUser=0;
   totalSmallestUser=0;
   

  gamma=gammaSet(ii,:);
   %for different channel
   for chan=1:channelnum
       ii
      chan
      [env,I,Q]=chtry(usernum,samplenum,30);
       
      %for diff samples
      for diffsamp=1:samplenum   

         
			for i=1:usernum
            user=I(i,:,diffsamp)+sqrt(-1)*Q(i,:,diffsamp);
            ch(i,:)=abs(fft(user,N)).^2*10^(pathdiff(i)/10);
			end

            
         [rheecapa,rheesuballo]=rheesub(Ptotal, ch, N, usernum, noise, gamma);

         [myp, outagecurrent]=shenpowerallo(ch,rheesuballo,N,usernum,Ptotal,noise,gamma);
         outage(ii)=outage(ii)+outagecurrent;

         
        for i=1:usernum
            mycapa(i)= waterfilling(myp(i),rheesuballo(i,:).*ch(i,:)/noise)/N;
            mycapaAllData(ii,chan,i)=mycapa(i);
	    end
             
        mycapaAccumulate(ii,:)=mycapaAccumulate(ii,:)+mycapa;

        totalLargerstUser=totalLargerstUser+waterfilling(Ptotal,ch(1,:)/noise)/N;
        totalSmallestUser=totalSmallestUser+waterfilling(Ptotal,ch(usernum,:)/noise)/N;
            
        [maxChValue, maxChUser]=max(ch);
        maxCapasubChannelAllo=zeros(usernum,N);
        MaxCapaPowerAllo=zeros(usernum,N);
        MaxCapaPoewrAlloVec=waterfillingPowerAllo(Ptotal,maxChValue./noise);
            
        for subChindex=1:N
            maxCapasubChannelAllo(maxChUser(subChindex),subChindex)=1;
            MaxCapaPowerAllo(maxChUser(subChindex),subChindex)=MaxCapaPoewrAlloVec(subChindex);
        end
            
           
            
        for i=1:usernum
            maxCapaUser(i)=sum(log2(1+MaxCapaPowerAllo(i,:).*ch(i,:)/noise))/N;
            maxCapaAllData(ii,chan,i)=maxCapaUser(i);
        end
            
        MaxCapaAccumulate(ii,:)=MaxCapaAccumulate(ii,:)+maxCapaUser;
            
        totalLeeCapa=totalLeeCapa+waterfilling(Ptotal,max(ch)/noise)/N;
            
            
			for i=1:usernum
    			tdma(i)=1/usernum*tdma_cap_cal(tdmaX,tdmap,N0,N,usernum,ch(i,:),B);
                tdmaCapaAllData(ii,chan,i)=tdma(i);
			end
            tdmaCapaAccumulate(ii,:)=tdmaCapaAccumulate(ii,:)+tdma;
            
            totalsumtdma=totalsumtdma+sum(tdma);

            totalmycapa=totalmycapa+sum(mycapa);

		%end diff sample
		end
   %end diff channel   
	end
   totalLargestUserVector(ii)=totalLargerstUser/(channelnum*samplenum);
   totalSmallestUserVector(ii)=totalSmallestUser/(channelnum*samplenum);
   totalLeeCapavector(ii)= totalLeeCapa/(channelnum*samplenum);
   sumtdmavector(ii)=totalsumtdma/(channelnum*samplenum);
   summycapavector(ii)=totalmycapa/(channelnum*samplenum);
   outage(ii)=outage(ii)/(channelnum*samplenum);
   

end
time2=clock
time2-time1
diffgamma=[0:gammaSetNum-1];
figure
plot(diffgamma,totalLeeCapavector(1:gammaSetNum),'k')
hold on
plot(diffgamma,totalLargestUserVector(1:gammaSetNum),'y')
plot(diffgamma,summycapavector(1:gammaSetNum), 'g+-.');
plot(diffgamma,sumtdmavector(1:gammaSetNum),'b*:')
plot(diffgamma,totalSmallestUserVector(1:gammaSetNum),'c')

grid on


for i=1:gammaSetNum
figure
barData=[gammaSet(i,:)/sum(gammaSet(i,:));mycapaAccumulate(i,:)/sum(mycapaAccumulate(i,:)); ...
        MaxCapaAccumulate(i,:)/sum(MaxCapaAccumulate(i,:));...
        tdmaCapaAccumulate(i,:)/sum(tdmaCapaAccumulate(i,:))]';
bar(barData)
end


