% Copyright (c) 2003-2004 The University of Texas
% All Rights Reserved.
%  
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%  
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%  
% The GNU Public License is available in the file LICENSE, or you
% can write to the Free Software Foundation, Inc., 59 Temple Place -
% Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
% World Wide Web at http://www.fsf.org.
%  
% Programmers:	Zukang Shen
% 
% The authors are with the Department of Electrical and Computer
% Engineering, The University of Texas at Austin, Austin, TX.
% They can be reached at shen@ece.utexas.edu.




worstpower=1.1565;
N=64;
B=1000000;
N0=worstpower*1e-7;
Ptotal=1;
noise=B*N0/N;
epsilong=1e-3;
channelnum=1;
samplenum=1;
positionnum=1;
tdmaX=ones(1,N);
tdmap=Ptotal/N*ones(1,N);
         

maxNumOfNewton=0;
maxTotalNewtonIteNum=0;
%for different user number
for ii=1:3
   outage=0;
   diffuser=4*ii+4;
   K=diffuser;
   totalminicapa=0;
   totalmintdma=0;
   totalavtdma=0;
   totalgain=0;
   totalgainfading=0;
   totalminfadingcapa=0;
   totalrheecapa=0;
   totalrheegain=0;
   totalmycapa=0;
   totalmygain=0;
   gamma=ones(1,K);
   %for different position
   
   for diffposition=1:positionnum
      
   position=rand(1,K);
  
   %for different channel
   for chan=1:channelnum
      chan
      [env,I,Q]=chtry(K,samplenum,30);
       
      %for diff samples
      for diffsamp=1:samplenum   
         diffuser;
         diffposition;
         chan;
         diffsamp;
         
			for i=1:K
            user=I(i,:,diffsamp)+sqrt(-1)*Q(i,:,diffsamp);
            ch(i,:)=abs(fft(user,N)).^2*10^(4*position(i));
			end

            
         [rheecapa,rheesuballo]=rheesub(Ptotal, ch, N, K, noise, gamma);
            
              
         myp=shenpowerallo(ch,rheesuballo,N,K,Ptotal,noise,gamma);
         
         
         for i=1:K
             mycapa(i)= waterfilling(myp(i),rheesuballo(i,:).*ch(i,:)/noise)/N;
	    end




			for i=1:K
    			tdma(i)=1/K*tdma_cap_cal(tdmaX,tdmap,N0,N,K,ch(i,:),B);
			end


            totalmintdma=totalmintdma+min(tdma);
            totalavtdma=totalavtdma+mean(tdma);
            totalrheecapa=totalrheecapa+min(rheecapa);
            totalrheegain=totalrheegain+min(rheecapa)-min(tdma);
            totalmycapa=totalmycapa+min(mycapa);
            totalmygain=totalmygain+min(mycapa)-min(tdma);
		%end diff sample
		end
   %end diff channel   
	end
   
   %end diff position
	end 
   
   mintdmavector(ii)=totalmintdma/(channelnum*samplenum)/positionnum;
   avtdmavector(ii)=totalavtdma/(channelnum*samplenum)/positionnum;
   minrheecapavector(ii)=totalrheecapa/(channelnum*samplenum)/positionnum;
   minmycapavector(ii)=totalmycapa/(channelnum*samplenum)/positionnum;
   

   gainrheevector(ii)=totalrheegain/(channelnum*samplenum)/positionnum;
   gainmyvector(ii)=totalmygain/(channelnum*samplenum)/positionnum;

   gainrheepervector(ii)=gainrheevector(ii)/mintdmavector(ii)*100;
   gainmypervector(ii)=gainmyvector(ii)/mintdmavector(ii)*100;
   
 
end

diffuservector=[8 12 16];
figure
plot(diffuservector,minmycapavector, 'g+-.');
hold on
plot(diffuservector,minrheecapavector, 'rd-.');
plot(diffuservector,mintdmavector,'b*:')
grid on
xlabel('number of users')
ylabel('capacity (bit/s/Hz)')
legend('proposed','method in [7]','TDMA');

grid on
minmycapavector
figure
plot(diffuservector,gainrheevector,'rd-.');
hold on
plot(diffuservector,gainmyvector,'g+-.');
grid on
xlabel('number of users')
ylabel('capacity gain (bit/s/Hz)')
legend('min-equal','min-optimal');

figure
plot(diffuservector,gainmypervector,'g+-.');
hold on
plot(diffuservector,gainrheepervector,'rd-.');

grid on
xlabel('number of users')
ylabel('capacity gain (%)')
legend('proposed/TDMA','method in [7]/TDMA');
