% Copyright (c) 2003-2004 The University of Texas
% All Rights Reserved.
%  
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%  
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%  
% The GNU Public License is available in the file LICENSE, or you
% can write to the Free Software Foundation, Inc., 59 Temple Place -
% Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
% World Wide Web at http://www.fsf.org.
%  
% Programmers:	Zukang Shen
% 
% The authors are with the Department of Electrical and Computer
% Engineering, The University of Texas at Austin, Austin, TX.
% They can be reached at shen@ece.utexas.edu.



function [env,I,Q]= chtry(userNum,sampleNum,fm)



Ts=1e-3;
N=200; %number of input waves
n=[0:N-1];
cita=2*pi*n/N; %input angles

for user=1:userNum
alfa1=randn(1,N); %magnitudes of input waves, tap 1
alfanormed(1,:)=alfa1/sqrt(sum(alfa1.^2)); %normalized magnitude, tap 1
alfa2=randn(1,N); %magnitudes of input waves, tap 2
alfanormed(2,:)=alfa2/sqrt(sum(alfa2.^2)); %normalized magnitude, tap 2
alfa3=randn(1,N); %magnitudes of input waves, tap 3
alfanormed(3,:)=alfa3/sqrt(sum(alfa3.^2)); %normalized magnitude, tap 3
alfa4=randn(1,N); %magnitudes of input waves, tap 4
alfanormed(4,:)=alfa4/sqrt(sum(alfa4.^2)); %normalized magnitude, tap 4
alfa5=randn(1,N); %magnitudes of input waves, tap 5
alfanormed(5,:)=alfa5/sqrt(sum(alfa5.^2)); %normalized magnitude, tap 5
alfa6=randn(1,N); %magnitudes of input waves, tap 6
alfanormed(6,:)=alfa6/sqrt(sum(alfa6.^2)); %normalized magnitude, tap 6

phaseinit1=randn(1,N);
phaseinit(1,:)=phaseinit1*2*pi/max(phaseinit1); %initial phases, tap 1
phaseinit2=randn(1,N);
phaseinit(2,:)=phaseinit2*2*pi/max(phaseinit2); %initial phases, tap 2
phaseinit3=randn(1,N);
phaseinit(3,:)=phaseinit3*2*pi/max(phaseinit3); %initial phases, tap 3
phaseinit4=randn(1,N);
phaseinit(4,:)=phaseinit4*2*pi/max(phaseinit4); %initial phases, tap 4
phaseinit5=randn(1,N);
phaseinit(5,:)=phaseinit5*2*pi/max(phaseinit5); %initial phases, tap 5
phaseinit6=randn(1,N);
phaseinit(6,:)=phaseinit6*2*pi/max(phaseinit6); %initial phases, tap 6

%using one-sided exponential profile
to=1*Ts;
tt=[0:5]*Ts;
g=exp(-tt/to);%relative engery for the 6 taps

    for j=1:6
        for i=0:sampleNum-1
            t=i*Ts;
            is=g(j)*sum(alfanormed(j,:).*cos(2*pi*fm*t*cos(cita)+phaseinit(j,:)));
            qs=g(j)*sum(alfanormed(j,:).*sin(2*pi*fm*t*cos(cita)+phaseinit(j,:)));
            I(user,j,i+1)=is;
            Q(user,j,i+1)=qs;
            envs=sqrt(qs^2+is^2);
            env(user,j,i+1)=envs;
        end
    end

end

for i=1:sampleNum
envtmp(i)=env(1,1,i);
end
% figure
% stem([0:sampleNum-1]*Ts, 20*log10(envtmp))
% title('Rayleigh Fading')
% xlabel('t')
% ylabel('r(t)')
% 
% figure
% stem([0:sampleNum-1]*Ts, envtmp)
% title('Rayleigh Fading')
% xlabel('t')
% ylabel('r(t)')


