% Copyright (c) 2003-2004 The University of Texas
% All Rights Reserved.
%  
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%  
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%  
% The GNU Public License is available in the file LICENSE, or you
% can write to the Free Software Foundation, Inc., 59 Temple Place -
% Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
% World Wide Web at http://www.fsf.org.
%  
% Programmers:	Zukang Shen
% 
% The authors are with the Department of Electrical and Computer
% Engineering, The University of Texas at Austin, Austin, TX.
% They can be reached at shen@ece.utexas.edu.

function [capacity,suballo] = rheesub (Ptot, ch, N, K, noise, gamma)

suballo=reshape(zeros(1,K*N),K,N);
capacity=zeros(1,K);
occupy=zeros(1,N);
ch=ch/noise;
p=Ptot/N;
used=zeros(1,N);
gammaVector=gamma;
for i=1:K
    temp=0;
    maxindex=0;
    for j=1:N
        if ((occupy(j)==0)&(ch(i,j)>temp))
            temp=ch(i,j);
            maxindex=j;
        end
    end
    capacity(i)=1/N*log2(1+p*ch(i,maxindex));
    occupy(maxindex)=1;
    used(maxindex)=i;
    suballo(i,maxindex)=1;
end

capacity=capacity(:);
gammaVector=gammaVector(:);
while (sum(occupy)<N)
    temp=max(capacity./gammaVector);
    
    for i=1:K;
        if (capacity(i)/gammaVector(i)<temp)
            temp=capacity(i)/gammaVector(i);
            minuser=i;
        end
    end
    
    temp=0;
    maxindex=0;
    for j=1:N
        if ((occupy(j)==0)&(ch(minuser,j)>temp))
            temp=ch(minuser,j);
            maxindex=j;
        end
    end
    capacity(minuser)=capacity(minuser)+1/N*log2(1+p*ch(minuser,maxindex));
    occupy(maxindex)=1;
    used(maxindex)=minuser;
    suballo(minuser,maxindex)=1;
end


