% Copyright (c) 2003-2004 The University of Texas
% All Rights Reserved.
%  
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%  
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%  
% The GNU Public License is available in the file LICENSE, or you
% can write to the Free Software Foundation, Inc., 59 Temple Place -
% Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
% World Wide Web at http://www.fsf.org.
%  
% Programmers:	Zukang Shen
% 
% The authors are with the Department of Electrical and Computer
% Engineering, The University of Texas at Austin, Austin, TX.
% They can be reached at shen@ece.utexas.edu.

function [p,outage]= shenpowerallo(channel,suballo,N,K,Ptot,noise,gamma)

for i=1:K
	n(i)=sum(suballo(i,:));   
end

for user=1:K
   used=[];
	for j=1:N
   	if suballo(user,j)>0
      	used=[used channel(user,j)];
   	end
	end

	usedlength=length(used);
	for i=1:length(used)
   	[minvalue minindex]=min(used);
   	usedordered(user,i)=minvalue;
   	used=[used(1:minindex-1) used(minindex+1:length(used))];
	end
   usedordered(user,:)=usedordered(user,:)/noise;	
   
   h(user)=usedordered(user,1);
   vtemp=0;
   for m=2:usedlength
   	vtemp=vtemp+(usedordered(user,m)-usedordered(user,1))/(usedordered(user,1)*usedordered(user,m));   
   end
   v(user)=vtemp;
   
   ytemp=1;
   for m=2:usedlength
   	ytemp=ytemp*usedordered(user,m)/usedordered(user,1);   
   end
   y(user)=ytemp;
   
end



coef(1)=1;
power(1)=1;

for i=2:K
    coef(i)=n(i)/(h(i)*y(i)^(1/n(i)))*(h(1)*y(1)^(1/n(1))/n(1))^(n(1)*gamma(i)/(n(i)*gamma(1)));
    power(i)=n(1)*gamma(i)/(n(i)*gamma(1));
end

infcheck=0;
for i=1:K
    if coef(i)==inf
        infcheck=1;
    end
end
if (infcheck==1)
   for i=1:K
      p(i)=Ptot/N*n(i);
   end
   outage=1;
   return;
end


fun=['x'];
for i=2:K
	fun=[fun,'+',num2str(coef(i)),'*x^',num2str(power(i))];   
end

for i=1:101
   guessx=0.01*(i-1)*Ptot;
   guess(i)=guessx;
   for j=2:K
   	guess(i)=guess(i)+coef(j)*guessx^power(j);   
   end
   
   guess(i)=guess(i)-Ptot;   
end


[guessvalue,guessindex]=min(abs(guess));

fun=[fun,'-',num2str(Ptot)];

p(1)=fzero(fun,0.01*(guessindex-1)*Ptot);

if isnan(p(1))==1
   for i=1:K
      p(i)=Ptot/N*n(i);
   end
   outage=1;
else 
   for i=2:K
      p(i)=coef(i)*p(1)^power(i);
   end
   outage=0;
end


