function [d,g] = Pdp(model)
switch model
    case 'officeA'
        d=[0 50 110 170 290 310]*1e-9;
        g=10.^([0 -3 -10 -18 -26 -32]/20);
        g=g/sqrt(sum(g.^2));
    case 'officeB'
        d=[0 100 200 300 500 700]*1e-9;
        g=10.^([0 -3.6 -7.2 -10.8 -18.0 -25.2]/20);
        g=g/sqrt(sum(g.^2));
    case 'pedestrianA'
        d=[0 110 190 410]*1e-9;
        g=10.^([0 -9.7 -19.2 -22.8]/20);
        g=g/sqrt(sum(g.^2));
    case 'pedestrianB'
        d=[0 200 800 1200 2300 3700]*1e-9;
        g=10.^([0 -0.9 -4.9 -8.0 -7.8 -23.9]/20);
        g=g/sqrt(sum(g.^2));
    case 'vehicularA'
        d=[0 310 710 1090 1730 2510]*1e-9;
        g=10.^([0 -1.0 -9.0 -10.0 -15.0 -20.0]/20);
        g=g/sqrt(sum(g.^2));
    case 'vehicularB'
        d=[0 300 8900 12900 17100 20000]*1e-9;
        g=10.^([-2.5 0 -12.8 -10.0 -25.2 -16.0]/20);
        g=g/sqrt(sum(g.^2));
    case 'flat'
        d=[0]*1e-9;
        g=10.^([0]/20);
        g=g/sqrt(sum(g.^2));
    otherwise
        disp('Unknown Channel Model')
        d=[];
        g=[]
        return
end