%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Experiments with OFDMA Resource Allocation %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
warning('off','MATLAB:divideByZero')
PLOT_CHAN = 0;
% close all
M = 2;                                  % No. of users
% Nfft = 2;                             % No. of subcarriers
% Nfftvec = [4,16,64,256];                  % No. of subcarriers
% colorvec = ['m','b','r','g'];
Nfftvec = [256];
colorvec = ['m'];

Nchan = 500;
BW = 5e6;                               % Bandwidth (Hz)
fc = 2.6e9;                             % Carrier frequency (Hz)
[Tau,gnorm] = Pdp('vehicularA');        % Power Delay Profile
c = 3e8;                                % Speed of light (m/s)
Velvec = [30, 75, 120, 180, 250]*1000/3600;
v = Velvec(2);                          % Velocity (m/s)
fd = v/c*fc;                            % Doppler Frequency (Hz)
tcoh = 1/(2*fd);                        % Coherence time (s)
lambda = 3e8/fc;                        % Wavelength (m)
fs = floor(8/7*BW/8000)*8000;           % Sampling Frequency (Hz)

SNR = 15;    % dB
sigma = 10^(-SNR/20); % standard deviation

% Generate channel
wvec = [0:0.05:1];
% wvec = 0;
for n = 1 :length(Nfftvec),
  Nfft = Nfftvec(n);
  C = zeros(M,length(wvec));
  G = zeros(1,length(wvec));
  I = G;
  L = G;
  nidx = [-Nfft/2:Nfft/2-1]';
  W = exp(-sqrt(-1)*2*pi*fs/Nfft*nidx*Tau);
  for c = 1 : Nchan,
    c
    h = (gnorm'*ones(1,M)).*(randn(length(gnorm),M)+j*randn(length(gnorm),M))/sqrt(2);
    H = W*h;
    %   if PLOT_CHAN,
    %     plot(10*log10(abs(H)))
    %   end;

    for i = 1:length(wvec),
      %     i = 6;
      w = [wvec(i),1-wvec(i)];
      [Gtmp, Itmp, Ltmp, Ctmp]=WeightedPerfectCSI(H,w,sigma/sqrt(Nfft),1);
      f = sum(w.*Ctmp);
      C(:,i) = C(:,i) + Ctmp'/Nchan;
      G(i) = G(i) + Gtmp/Nchan;
      I(i) = I(i) + Itmp/Nchan;
      L(i) = L(i) + Ltmp/Nchan;
    end;
  end;
  figure(1)
  plot(C(1,:),C(2,:),[colorvec(n),'x-.'])
  grid on
  hold on
  title('Capacity Region for 2 Users')
  xlabel('Capacity for user 1 (bps/Hz)')
  ylabel('Capacity for user 2 (bps/Hz)')
  figure(2)
  semilogy(wvec,G,[colorvec(n),'x-.'])
  grid on
  hold on
  figure(3)
  plot(wvec,I,[colorvec(n),'x-.'])
  hold on
  grid on
  figure(4)
  plot(wvec,L,[colorvec(n),'x-.'])
  hold on
  grid on
end;
% figure
% plot(wvec,G)
% grid on
% title('Duality Gap')
% xlabel('User 1 Weight')
% figure
% plot(wvec,10*log10(I))
% title('No. of Iterations')


