%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Experiments with OFDMA Resource Allocation %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
PLOT_CHAN =0;
close all
% M = 2;                                  % No. of users
Mvec = [2,4,8,16];
% Nfftvec = [2,4,6,16];                  % No. of subcarriers
% colorvec = ['m','b','r','g'];
% Nfftvec = [2,256];                  % No. of subcarriers
% colorvec = ['m','b'];
Nfftvec = 256;
colorvec = 'b';
Nchan = 100;
BW = 5e6;                               % Bandwidth (Hz)
fc = 2.6e9;                             % Carrier frequency (Hz)
[Tau,gnorm] = Pdp('vehicularA');        % Power Delay Profile
c = 3e8;                                % Speed of light (m/s)
Velvec = [30, 75, 120, 180, 250]*1000/3600;
v = Velvec(2);                          % Velocity (m/s)
fd = v/c*fc;                            % Doppler Frequency (Hz)
tcoh = 1/(2*fd);                        % Coherence time (s)
lambda = 3e8/fc;                        % Wavelength (m)
fs = floor(8/7*BW/8000)*8000;           % Sampling Frequency (Hz)

% SNRvec = [5:5:20];
SNR = 0;    % dB
sigma = 10^(-SNR/20); % standard deviation

% Generate channel
% wvec = [0:0.05:1];
% wvec = linspace(0,1,5);
% wvec = [0.25];
% wvec = 0;

C = zeros(1,length(Mvec));
G = zeros(1,length(Mvec));
Gb = G;
I = G;
Lmin = G;
L = G;
Lmax = G;

for m = 1 : length(Mvec),
  M = Mvec(m);
  userweight = ones(1,M);
  
  for n = 1 :length(Nfftvec),
    Nfft = Nfftvec(n);
    nidx = [-Nfft/2:Nfft/2-1]';
    W = exp(-sqrt(-1)*2*pi*fs/Nfft*nidx*Tau);
    for c = 1 : Nchan,
      c
      h = (gnorm'*userweight).*(randn(length(gnorm),M)+j*randn(length(gnorm),M))/sqrt(2);
      H = W*h;
      %     H = (randn(Nfft,M)+sqrt(-1)*randn(Nfft,M))/sqrt(2);
      if PLOT_CHAN,
        figure(4)
        plot(10*log10(abs(H)))
      end;
     
      for i = 1:length(wvec),
        [Gtmp, Gbndtmp,Itmp, Lmintmp, Ltmp, Lmaxtmp, Ctmp]=WeightedPerfectCSI(H,w,sigma,Nfft,1);
        C(m) = C(m) + Ctmp/Nchan;
        G(m) = G(m) + Gtmp/Nchan;
        Gb(m) = Gb(m) + Gbndtmp/Nchan;
        I(m) = I(m) + Itmp/Nchan;
        Lmin(m) = Lmin(m) + Lmintmp/Nchan;
        L(m) = L(m) + Ltmp/Nchan;
        Lmax(m) = Lmax(m) + Lmaxtmp/Nchan;
      end;
    end;
  end;
end;
figure(1)
    plot(Mvec,C,colorvec(n))
    hold on
    grid on
    title('Capacity')
    xlabel('No. of Users')
%     ylabel('Capacity for user 2 (bps/Hz)')
    figure(2)
    semilogy(Mvec,G,colorvec(n))
    hold on
    figure(3)
    plot(Mvec,I,colorvec(n))
    hold on
    figure(4)
    plot(Mvec,Lmin,[colorvec(n),'--'],Mvec,L,[colorvec(n),'-'],Mvec,Lmax,[colorvec(n),':'])
    hold on

% figure
% plot(wvec,G)
% grid on
% title('Duality Gap')
% xlabel('User 1 Weight')
% figure
% plot(wvec,10*log10(I))
% title('No. of Iterations')


