%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Experiments with OFDMA Resource Allocation %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
warning('off','MATLAB:divideByZero')
CSI_Type = 0; % 0 - Perfect, 1 - Predicted
PLOT_CHAN = 0;
% close all
M = 2;                                  % No. of users
% Nfft = 2;                             % No. of subcarriers
% Nfftvec = [4,16,64,256];                  % No. of subcarriers
Nfftvec = 256;
Nu = 129;
CPfrac = 1/16;                          % Fraction of Nfft for CP
colorvec = ['m','b','r','g'];

Nchan = 1000;
BW = 1.25e6;                               % Bandwidth (Hz)
fc = 2.6e9;                             % Carrier frequency (Hz)
[tau,gnorm] = Pdp('vehicularA');        % Power Delay Profile
c = 3e8;                                % Speed of light (m/s)
Velvec = [30, 75, 120, 180, 250]*1000/3600;
v = Velvec(5);                          % Velocity (m/s)
fd = v/c*fc;                            % Doppler Frequency (Hz)
tcoh = 1/(2*fd);                        % Coherence time (s)
lambda = 3e8/fc;                        % Wavelength (m)
fs = floor(8/7*BW/8000)*8000;           % Sampling Frequency (Hz)


% Prediction params
P = 1;
Dt = 21;

SNR = 5;    % dB
sigma = 10^(-SNR/20); % standard deviation
BER = 1e-3;
R = [0:2:6];
Eta = -log(5*BER)/1.6*(2.^R-1);
% Generate channel
wvec = 0.1:0.1:0.9;
% wvec = 0;
for n = 1 :length(Nfftvec),
  Nfft = Nfftvec(n);
  tsym = Nfft*(1+CPfrac)/fs;
  C = zeros(M,length(wvec));
  G = zeros(1,length(wvec));
  I = G;
  L = G;

  C2 = zeros(M,length(wvec));
  G2 = zeros(1,length(wvec));
  I2 = G;
  L2 = G;

  C3 = zeros(M,length(wvec));
  G3 = zeros(1,length(wvec));
  I3 = G;
  L3 = G;
  
  C4 = zeros(M,length(wvec));
  G4 = zeros(1,length(wvec));
  I4 = G;
  L4 = G;
  
  C5 = zeros(M,length(wvec));
  G5 = zeros(1,length(wvec));
  I5 = G;
  L5 = G;
  
  C6 = zeros(M,length(wvec));
  G6 = zeros(1,length(wvec));
  I6 = G;
  L6 = G;
  %   if CSI_Type == 0
  H = channel(M, Nchan, fs, Nu, Nfft, tau, gnorm);
  %   else
%   [Hhat,sigma2ehat] = channelpred(M, Nchan, fs, tsym, Nu, tau, gnorm, fd, P, Dt, CPfrac, sigma^2);
%   E = (randn(size(H))/sqrt(2)+sqrt(-1)*randn(size(H))/sqrt(2)).*repmat(sigma2ehat,[1,M,Nchan]);
  %   end
  Gamma = zeros(size(H));
%   for c = 1 : Nchan
%     c
%     Gamma(:,:,c) = abs(H(:,:,c)).^2./(sigma^2);
% %     Gammahat = abs(H(:,:,c)-E(:,:,c)).^2./(sigma^2);
%   end;

    for i = 1:length(wvec),
%               i = 5;
      w = [wvec(i),1-wvec(i)];
%       [Gtmp, Itmp, Ltmp, Ctmp,P]=ExpectedWeightedPerfectCSI(Gamma,Gamma,w,1); 
      [Gtmp, Itmp, Ltmp, Ctmp]=ExpectedWeightedPerfectCSI2(w,[1,1]/sigma^2,1,Nu);
%     end;
%      for i = 1,
%       [Gtmp2, Itmp2, Ltmp2, Ctmp2, P2]=ExpectedWeightedImperfectCSI(Gammahat,Gamma,sigma^2,sigma2ehat,w,1);
%       [Gtmp3, Itmp3, Ltmp3, Ctmp3, P3]=ExpectedWeightedPerfectCSI(Gammahat,Gamma,w,1);
%       [Gtmp4, Itmp4, Ltmp4, Ctmp4, P4] = ExpectedDiscretePerfectCSI(Gamma,Gamma,w,Nu,R,Eta);
%       [Gtmp5, Itmp5, Ltmp5, Ctmp5, P5] = ExpectedDiscreteImperfectCSI(Gammahat,Gamma,sigma^2,sigma2ehat,w,Nu,R,Eta,BER);
%       [Gtmp6, Itmp6, Ltmp6, Ctmp6, P6] = ExpectedDiscretePerfectCSI(Gammahat,Gamma,w,Nu,R,Eta);
%       f = sum(w.*Ctmp);
      C(:,i) = C(:,i) + Ctmp';
      G(i) = G(i) + Gtmp;
      I(i) = I(i) + Itmp;
      L(i) = L(i) + Ltmp;
% 
%       f2 = sum(w.*Ctmp2);
%       C2(:,i) = C2(:,i) + Ctmp2'/Nchan;
%       G2(i) = G2(i) + Gtmp2/Nchan;
%       I2(i) = I2(i) + Itmp2/Nchan;
%       L2(i) = L2(i) + Ltmp2/Nchan;

%       f3 = sum(w.*Ctmp3);
%       C3(:,i) = C3(:,i) + Ctmp3'/Nchan;
%       G3(i) = G3(i) + Gtmp3/Nchan;
%       I3(i) = I3(i) + Itmp3/Nchan;
%       L3(i) = L3(i) + Ltmp3/Nchan;
      
%       f4 = sum(w.*Ctmp4);
%       C4(:,i) = C4(:,i) + Ctmp4'/Nchan;
%       G4(i) = G4(i) + Gtmp4/Nchan;
%       I4(i) = I4(i) + Itmp4/Nchan;
%       L4(i) = L4(i) + Ltmp4/Nchan;
%       
%       f5 = sum(w.*Ctmp5);
%       C5(:,i) = C5(:,i) + Ctmp5'/Nchan;
%       G5(i) = G5(i) + Gtmp5/Nchan;
%       I5(i) = I5(i) + Itmp5/Nchan;
%       L5(i) = L5(i) + Ltmp5/Nchan;
%       
%       f6 = sum(w.*Ctmp5);
%       C6(:,i) = C6(:,i) + Ctmp6'/Nchan;
%       G6(i) = G6(i) + Gtmp6/Nchan;
%       I6(i) = I6(i) + Itmp6/Nchan;
%       L6(i) = L6(i) + Ltmp6/Nchan;
    end;
  end;
% end;
figure(1)
plot(C(1,:),C(2,:))%,'-',C2(1,:),C2(2,:),'--',C3(1,:),C3(2,:),'-.')
% plot(C4(1,:),C4(2,:),'-',C5(1,:),C5(2,:),'--',C6(1,:),C6(2,:),'-.')
grid on
hold on
title('Capacity Region for 2 Users')
xlabel('Capacity for user 1 (bps/Hz)')
ylabel('Capacity for user 2 (bps/Hz)')
legend('P-CSI: WF','I-CSI: Opt','I-CSI: WF')
figure(2)
semilogy(wvec,G4,[colorvec(n),'x-'])
grid on
hold on
figure(3)
plot(wvec,I,[colorvec(n),'x-'])
hold on
grid on
figure(4)
plot(wvec,L,[colorvec(n),'x-'])
hold on
grid on
% end;
figure
plot(wvec,G)
grid on
title('Duality Gap')
xlabel('User 1 Weight')
figure
plot(wvec,10*log10(I))
title('No. of Iterations')

