%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Experiments with OFDMA Resource Allocation %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
warning('off','MATLAB:divideByZero')
PLOT_CHAN = 0;
% close all
M = 2;                                  % No. of users
% Nfft = 2;                             % No. of subcarriers
% Nfftvec = [4,16,64,256];                  % No. of subcarriers
Nfftvec = 256;
colorvec = ['m','b','r','g'];

Nchan = 100;
BW = 5e6;                               % Bandwidth (Hz)
fc = 2.6e9;                             % Carrier frequency (Hz)
[Tau,gnorm] = Pdp('vehicularA');        % Power Delay Profile
c = 3e8;                                % Speed of light (m/s)
Velvec = [30, 75, 120, 180, 250]*1000/3600;
v = Velvec(2);                          % Velocity (m/s)
fd = v/c*fc;                            % Doppler Frequency (Hz)
tcoh = 1/(2*fd);                        % Coherence time (s)
lambda = 3e8/fc;                        % Wavelength (m)
fs = floor(8/7*BW/8000)*8000;           % Sampling Frequency (Hz)

SNR = 15;    % dB
sigma = 10^(-SNR/20); % standard deviation

% Generate channel
wvec = [0:0.1:1];
% wvec = 0;
for n = 1 :length(Nfftvec),
  Nfft = Nfftvec(n);
  C = zeros(M,length(wvec));
  G = zeros(1,length(wvec));
  I = G;
  L = G;
  Gamma = zeros(Nfft,M,Nchan);
  nidx = [-Nfft/2:Nfft/2-1]';
  W = exp(-sqrt(-1)*2*pi*fs/Nfft*nidx*Tau);
  Rhh = W*diag(gnorm.^2)*W';
  Ree = Rhh - Rhh*inv(Rhh+sigma^2*eye(size(Rhh)))*Rhh;
  [Ue,De] = eig(Ree);
  Reesqrt = Ue*diag(sqrt(diag(De)))*Ue';
  e = Reesqrt*(randn(Nfft,1)+sqrt(-1)*randn(Nfft,1))/sqrt(2);
  P = 8;
  Dt = 4;
  r = besselj(0,2*pi*fd*[0:P]*Dt*1/fs*Nfft*(1+1/8));
  for c = 1 : Nchan,
%     c;
    h = (gnorm'*ones(1,M)).*(randn(length(gnorm),M)+j*randn(length(gnorm),M))/sqrt(2);
    Gamma(:,:,c) = (abs(W*h).^2)/(sigma^2/Nfft);
  end;    
  for i = 1:length(wvec),
    %     i = 6;
    w = [wvec(i),1-wvec(i)];
    [Gtmp, Itmp, Ltmp, Ctmp]=ExpectedWeightedPerfectCSI(Gamma,w,1);
    f = sum(w.*Ctmp);
    C(:,i) = C(:,i) + Ctmp'/Nchan;
    G(i) = G(i) + Gtmp/Nchan;
    I(i) = I(i) + Itmp/Nchan;
    L(i) = L(i) + Ltmp/Nchan;
  end;
end;
%   figure(1)
%   plot(C(1,:),C(2,:),[colorvec(n),'x-'])
%   grid on
%   hold on
%   title('Capacity Region for 2 Users')
%   xlabel('Capacity for user 1 (bps/Hz)')
%   ylabel('Capacity for user 2 (bps/Hz)')
%   figure(2)
%   semilogy(wvec,G,[colorvec(n),'x-'])
%   grid on
%   hold on
%   figure(3)
%   plot(wvec,I,[colorvec(n),'x-'])
%   hold on
%   grid on
%   figure(4)
%   plot(wvec,L,[colorvec(n),'x-'])
%   hold on
%   grid on
% end;
% figure
% plot(wvec,G)
% grid on
% title('Duality Gap')
% xlabel('User 1 Weight')
% figure
% plot(wvec,10*log10(I))
% title('No. of Iterations')


