% Testing approximation to Imperfect CSI power allocation function
g0 = 1;
R = 0:2:6;
BER = 1e-3;
Eta = -log(5*BER)/1.6*(2.^R-1);
ghatvec = linspace(-5,15,41);
gbarvec = 10.^((-5:-5:-15)/10);
p = zeros(length(R),length(gbarvec),length(ghatvec));
c = zeros(length(R),length(gbarvec),length(ghatvec));
pwf = zeros(length(R),length(ghatvec));
for i = 1:length(gbarvec)
  gbar = gbarvec(i);
  for j = 1:length(ghatvec)
    i,j
    ghat = 10^(ghatvec(j)/10);
    p(:,i,j) = PowerDiscreteImperfectCSI(ghat,1,gbar,R,Eta,BER);
    c(:,i,j) = DualDiscreteImperfect(1,ghat,1,gbar,p(:,i,j),R,Eta);
    if i==1
      pwf(:,j) = Eta./ghat;
    end
  end
end
semilogy(ghatvec,squeeze(p(1,1,:)),'b:','Linewidth',1.5)
hold on
semilogy(ghatvec,squeeze(p(1,2,:)),'b--','Linewidth',1.5)
semilogy(ghatvec,squeeze(p(1,3,:)),'b-.','Linewidth',1.5)
semilogy(ghatvec,pwf(1,:),'b-','Linewidth',1.5)
% semilogy(ghatvec,squeeze(p(1,4,:)),'b:','Linewidth',1)
semilogy(ghatvec,squeeze(p(2,1,:)),'r:','Linewidth',1.5)
semilogy(ghatvec,squeeze(p(2,2,:)),'r--','Linewidth',1.5)
semilogy(ghatvec,squeeze(p(2,3,:)),'r-.','Linewidth',1.5)
% semilogy(ghatvec,squeeze(p(2,4,:)),'r:','Linewidth',1)
semilogy(ghatvec,pwf(2,:),'r-','Linewidth',1.5)
grid on
xlabel('\gamma (dB)')
ylabel('power')
figure
plot(ghatvec,squeeze(c(1,1,:)),'b:','Linewidth',1.5)
hold on
plot(ghatvec,squeeze(c(1,2,:)),'b--','Linewidth',1.5)
semilogy(ghatvec,squeeze(c(1,3,:)),'b-.','Linewidth',1.5)
% semilogy(ghatvec,squeeze(p(1,4,:)),'b:','Linewidth',1)
plot(ghatvec,squeeze(c(2,1,:)),'r:','Linewidth',1.5)
plot(ghatvec,squeeze(c(2,2,:)),'r--','Linewidth',1.5)
plot(ghatvec,squeeze(c(2,3,:)),'r-.','Linewidth',1.5)
plot(ghatvec,squeeze(c(3,1,:)),'g:','Linewidth',1.5)
plot(ghatvec,squeeze(c(3,2,:)),'g--','Linewidth',1.5)
plot(ghatvec,squeeze(c(3,3,:)),'g-.','Linewidth',1.5)
plot(ghatvec,squeeze(c(4,1,:)),'m:','Linewidth',1.5)
plot(ghatvec,squeeze(c(4,2,:)),'m--','Linewidth',1.5)
plot(ghatvec,squeeze(c(4,3,:)),'m-.','Linewidth',1.5)

% semilogy(ghatvec,squeeze(p(2,4,:)),'r:','Linewidth',1)
grid on
xlabel('\gamma (dB)')
ylabel('Average rate')
save TestDiscImpCSIPowalloc