% Testing approximation to Imperfect CSI power allocation function
g0 = 1;
ghatvec = linspace(-5,15,41);
gbarvec = 10.^((-10:5:5)/10);
p = zeros(length(gbarvec),length(ghatvec));
papp = p;
pwf = zeros(1,length(ghatvec));
t = 0;
t2 = 0;
for i = 1:length(gbarvec)
  gbar = gbarvec(i);
  for j = 1:length(ghatvec)
    i,j
    ghat = 10^(ghatvec(j)/10);
    tic
    if ghat+gbar<g0
      p(i,j)=0;
    else
      p(i,j) = fzero(@(x) PowerImperfectCSI(x,ghat,1,gbar,g0,log(2)),[0,1/g0]);
    end;
    t=t+toc;
    if i==1
      pwf(j) = max(1/g0-1/ghat,0);
    end
    tic
    papp(i,j) = approxPAimpCSI(ghat,gbar,g0,[0,1/g0]);
    t2 = t2 + toc;
  end
end
t
t2
plot(ghatvec,p,'-')
hold on
plot(ghatvec,papp,'x')
plot(ghatvec,pwf,'--')
xlabel('\gamma (dB)')
ylabel('power')
save TestImpCSIPowalloc