% Testing analytical discrete rate perfect CSI case
warning('off','MATLAB:divideByZero')
R = 0:2:6;
BER = 1e-3;
Rext = [-inf,R,R(end)];
Eta = -log(5*BER)/1.6*(2.^R-1);
Etaext = [0,Eta,inf];
Slopes = (Rext(2:end)-Rext(1:end-1))./(Etaext(2:end)-Etaext(1:end-1));
gvec = linspace(0,8,501);
gbar = 10^(5/10);
w = 1;
l = .1;
Fg = zeros(size(gvec));
fg = zeros(size(gvec));
for i = 1 : length(gvec)
  Fg(i) = lmaxcdf3vec(gvec(i),l,w,gbar,Etaext,Rext);
  fg(i) = lmaxpdf3vec(gvec(i),l,w,gbar,Etaext,Rext);
end;
figure
plot(gvec,Fg,'b--','LineWidth',2)
hold on
plot(gvec,fg+Fg(1)*[1,zeros(1,length(fg)-1)],'b--','LineWidth',2)
tot = quad(@(x) lmaxpdf3vec(x,l,w,gbar,Etaext,Rext), 0, 8,1e-15)+Fg(1)
hold on
% Use monte carlo to test pdfs
N = 1000000;
G = exprnd(gbar,1,N);
maxl = max(repmat(w*R',1,N)-l*Eta'*(1./G));
[H] = histc(maxl,gvec);
dx = gvec(2)-gvec(1);
PDFemp = H/(N*dx);
bar(gvec,PDFemp,'histc')
CDFemp = cumsum(PDFemp*dx);
% for i = 1 : N
%   if mod(i,1000)==0
%     i
%   end
%   g = exprnd
% end

