function C = WeightedPartialCSIConst(Gamma,Gammatrue,w,sigma2w,sigma2e,Pbar)
[K,M] = size(Gamma);
Cmat3 = zeros(K,M);
Ptmp = zeros(K,M);
for k = 1 : K
  for m = 1 : M
    gbar = sigma2e(k)/sigma2w;
    ghat = Gamma(k,m);
    Cmat3(k,m) = quad(@(x) myintegrand(x,Pbar/K,ghat,gbar),0,ghat+gbar+10*sqrt(gbar^2+2*ghat*gbar));
  end;
end;
[WCtmp3,WCtmp3idx] = max(repmat(w,size(Gamma,1),1).*Cmat3,[],2);
linidx = sub2ind(size(Gamma),(1:size(Gamma,1))',WCtmp3idx);
Ptmp(linidx) = Pbar/K;
Ctmp = log2(1+Ptmp.*Gammatrue);
C = sum(Ctmp);
end

function y = myintegrand(x,p,ghat,gbar)
y = log2(1+p*x)/gbar.*exp(-(ghat+x)/gbar).*besseli(0,2/gbar*sqrt(ghat*x));
y(isinf(y)|isnan(y))=0;
end

