function [Reesqrt, Resqrt, sigma2ehat] = channelpred(M, Nr, fs, tsym, Nfft, Nu, tau, gnorm, fd, P, Dt, CPfrac, sigma2e)
tau = tau(:);
gnorm = gnorm(:);

nidx = (-(Nu-1)/2:(Nu-1)/2)';
W = exp(-sqrt(-1)*2*pi*fs/Nfft*nidx*tau');
rt = besselj(0,2*pi*fd*tsym*Dt*(0:P));
Rt = toeplitz(rt(1:end-1));
Rh = W*diag(gnorm.^2)*W';
Rhat = kron(rt(2:end),Rh);
[U1,D1,V1] = svd(Rt);
[U2,D2,V2] = svd(Rh);
Rhathat = kron(Rt,Rh) + sigma2e*eye(P*Nu);
d = Rhathat\Rhat';
Re = Rh - Rhat*d;
sigma2ehat = real(diag(Re));
Up = kron(U1,U2);
Dp = kron(D1,D2)+sigma2e*eye(P*Nu);
Resqrt = Rhat*Up*diag(sqrt(1./real(diag(Dp))));
% for i = 1 : Nr
%     H(:,:,i) = Resqrt*R(:,:,i);
% end;
% H = H((-Nu/2+1:Nu/2)+Nfft/2,:);
[Ue,De,Ve] = svd(Re);
Reesqrt = Ue*diag(sqrt(real(diag(De))));
% idx = (-Nu/2+1:Nu/2)+Nfft/2;
% sigma2ehat = sigma2ehat(idx);
% Reesqrt = Reesqrt(idx,idx);
