% Test Script for noise estimaton using AMP 

%% System Setup
fftSize = 256;

noiseParams.impPrb = 0.05;
noiseParams.impPwr = 0.25;
noiseParams.bckPwr = 0.0025;

nGampItr = 20;
nTrials = 100;

%% Impulse and background noise generation function 
genImpNoise = @(size) genGmNoise(size,struct('nComps',2,...
    'mixVec',[1-noiseParams.impPrb  noiseParams.impPrb ],...
    'vars',[noiseParams.bckPwr noiseParams.bckPwr+noiseParams.impPwr]));

%% Select null tones
% nNullTones = 64;
% nullTones = 1:nNullTones; 
%g3NullTones = [1:32 105:160 233:256];
g3NullTones = [2:23 60:101 156:197 234:256];
nullTones = g3NullTones;

%% Setup Dynamic Range Scopes
% hscope_pvar         = NumericTypeScope;
% hscope_phat         = NumericTypeScope;
% hscope_zhat         = NumericTypeScope;
% hscope_shat         = NumericTypeScope;
% hscope_svar         = NumericTypeScope;
% hscope_rvar         = NumericTypeScope;
% hscope_rhat         = NumericTypeScope;
% hscope_gain         = NumericTypeScope;
% hscope_mgRsq        = NumericTypeScope;
% hscope_LR           = NumericTypeScope;
% hscope_ifftAugShat  = NumericTypeScope;
% hscope_ilrExpTerm   = NumericTypeScope;
hscope_expArg  = NumericTypeScope;
% hscope_expTerm  = NumericTypeScope;
% hscope_prbImpgvR    = NumericTypeScope;
% hscope_ihat         = NumericTypeScope;
% hscope_ivar         = NumericTypeScope;

for iTrial = 1:nTrials
    
    %% generate impulse noise in time-domain
    imp = genImpNoise([fftSize 1]);
    frqImp = fft(imp)/sqrt(fftSize);
    
    %% Estimate
    [impEst,estHist] = ampnest(frqImp(nullTones),fftSize,nullTones,noiseParams,nGampItr);
    
    %% Analyze Dynamic Range
%     step(hscope_pvar,estHist.pvar);
%     step(hscope_phat,estHist.phat);
%     step(hscope_zhat,estHist.zhat);
%     step(hscope_shat,estHist.shat);
%     step(hscope_svar,estHist.svar);
%     step(hscope_rvar,estHist.rvar);
%     step(hscope_rhat,estHist.rhat);
%     step(hscope_gain,estHist.gain);
%     step(hscope_mgRsq,estHist.mgRsq);
%     step(hscope_LR,estHist.LR);
%     step(hscope_ifftAugShat,estHist.ifftAugShat);
%     step(hscope_ilrExpTerm,estHist.ilrExpTerm);
    step(hscope_expArg,estHist.expArg);
%     step(hscope_expArg,estHist.expTerm);
%     step(hscope_prbImpgvR,estHist.prbImpgvR);
%     step(hscope_ihat,estHist.ihat);
%     step(hscope_ivar,estHist.ivar);

end;
