function [ noiseSamples ] = genGmNoise( size, params, iscomplex )
% Generate Gaussian mixture noise
%   Syntax: NOISESAMPLES = genGmNoise(SIZE,PARAMS,ISCOMPLEX*)
%
%   SIZE - the dimensions of the generated noise samples
%   PARAMS - noise parameters struct
%               nComps: number of mixture components
%               mixVec: probability vector of each component
%               vars: variances of each component
%   ISCOMPLEX* - indicates whether the generated samples are complex (default: true)
%   NOISESAMPLES - the generated noise samples

% Generate noise samples
if nargin == 2 || iscomplex
    stdNormalNoise = (randn(size) + 1i*randn(size))/sqrt(2);
else
    stdNormalNoise = randn(size);
end

% Generate States
noiseStates = randsample(params.nComps, prod(size), true, params.mixVec); % TODO
%  Shape noise according to its state
scale = realsqrt(params.vars);
noiseSamples = reshape(scale(noiseStates),size)...
    .* stdNormalNoise;

end

