function [ w ] = sblBasisSel( t, phi, nEmItr )
% Implements Sparse Bayesian Learning Basis Selection for overcomplete
% dictionaries.
%
% References: 
% Tipping, M. E. (2001). Sparse Bayesian learning and the relevance vector
% machine. Journal of Machine Learning Research  1, 211244.

nObs = length(t);
nBasis = size(phi,2);

% Initialize Parameters
nextItrSigmaSq = 1; % noise variance
nextItrGamma = eye(nBasis); % prior hyperparameters gamma = diag{hyperparams}

% Evidence Approximation using EM
for itEM = 1:nEmItr % TODO : add covergence criteria
    % Assign new values to paramters
    gamma = nextItrGamma;
    sigmaSq = nextItrSigmaSq;
    % Compute new parameters
    cov_t = sigmaSq*eye(nObs) + phi*gamma*phi';
    cov_w = gamma - gamma*phi'/cov_t*phi*gamma;
    mu_w = cov_w*phi'*t/sigmaSq;
    nextItrGamma = diag(real(diag(cov_w)) + abs(mu_w).^2);
    assert(isreal(nextItrGamma)); % TODO
    nextItrSigmaSq = 1/nObs*(norm(t-phi*mu_w)^2 + ...
        sigmaSq*sum(1-real(diag(cov_w))./diag(gamma)));
end
% ML point estimate
w = mu_w(:); 
end
