function [ decodSyms ] = sblDecode( rcvSig,nullToneList,symDemod,nEmItr )
% Performs Sparse Bayesian Learning null-tone based OFDM decoding based on [1]. 
%
%   rcvSig: received signal time x nOfdmframes
%   nullToneList: list of null tones in each ofdm symbol
%   symDemod: symbol demodulator (see communication toolbox)
%   nEmItr: number of EM iteration in the SBL
%   decodSyms: a stream of decoded symbols
%
% [1] J. Lin, M. Nassar and B. L. Evans, "Non-Parametric Impulsive Noise
%     Mitigation in OFDM Systems Using Sparse Bayesian Learning", 
%     Proc. IEEE Int. Global Communications Conf., Dec. 5-9, 2011, 
%     Houston, TX USA. 

% Arranging data into the System Model Format
fftSize = size(rcvSig,1);
F = 1/realsqrt(fftSize) * dftmtx(fftSize); % normalized DFT mtx

% Switching to paper notation (See Reference)
y = 1/realsqrt(fftSize)*fft(rcvSig,fftSize,1);
yNull = y(nullToneList,:); % y_I
FNull = F(nullToneList,:); % F_I

% SBL by EM
noiseEst = arrayfun(@(indx) sblBasisSel(yNull(:,indx),FNull,nEmItr),1:size(yNull,2),'UniformOutput',false);
noiseEst = [noiseEst{:}];

% Denoise received signal
densdRcvSig = rcvSig - noiseEst;

% Detection
demodSymbols = 1/realsqrt(fftSize)*fft(densdRcvSig,fftSize,1);
signalNorm = 1/modnorm(symDemod.constellation, 'avpow',1);
dataToneList = setdiff(1:fftSize,nullToneList);
[dataTonesSignal] = demodSymbols(dataToneList,:);
decodSyms = reshape(demodulate(symDemod, signalNorm*dataTonesSignal),[],1);

end

