% Generates SER using SBL decoding

N = 128; % number of tones
nullToneList = 1:64;
M = 4; % modulation order
symMod = modem.qammod(M);

prbImp = 0.01; % probability of impulse
impPwr = 100; % impulse power
bckPwr = 1; % background noise power

nOfdmSymbols = 100; % number of Ofdm symbols to generate

syms = randi([0 M-1],[N nOfdmSymbols]); % generate syms
trsSyms = modulate(symMod,syms);
trsSyms(nullToneList,:) = 0; % insert null tones

% send through channel and add noise
noise = sqrt(bckPwr/2)*(randn(N,nOfdmSymbols) + 1i*randn(N,nOfdmSymbols)) ...
    +  sqrt(impPwr/2)*(rand(N,nOfdmSymbols)<prbImp) .* ...
    (randn(N,nOfdmSymbols) + 1i*randn(N,nOfdmSymbols));
rcvSig = ifft(trsSyms,[],1)*sqrt(N) + noise; 

% decode
nEmItr = 100;
symDemod = modem.qamdemod(M);
[ decodSyms ] = sblDecode( rcvSig,nullToneList,symDemod,nEmItr );

% display results
dataTones = setdiff(1:N,nullToneList);
cmrSyms = syms(dataTones,:);
disp(['Number of sent symbols: ' num2str(length(cmrSyms(:)))]);
disp(['Number of errors: ' num2str(sum(cmrSyms(:)~=decodSyms))]);

