function varargout = rfidemo_pest(varargin)
% RFIDEMO_PEST M-file for rfidemo_pest.fig
%      RFIDEMO_PEST, by itself, creates a new RFIDEMO_PEST or raises the existing
%      singleton*.
%
%      H = RFIDEMO_PEST returns the handle to a new RFIDEMO_PEST or the handle to
%      the existing singleton*.
%
%      RFIDEMO_PEST('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFIDEMO_PEST.M with the given input arguments.
%
%      RFIDEMO_PEST('Property','Value',...) creates a new RFIDEMO_PEST or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rfidemo_pest_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rfidemo_pest_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help rfidemo_pest

% Last Modified by GUIDE v2.5 08-May-2007 23:48:58

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rfidemo_pest_OpeningFcn, ...
                   'gui_OutputFcn',  @rfidemo_pest_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rfidemo_pest is made visible.
function rfidemo_pest_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rfidemo_pest (see VARARGIN)

% Choose default command line output for rfidemo_pest
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rfidemo_pest wait for user response (see UIRESUME)
% uiwait(handles.rfidemopestfig);

% initialize state variables
global paramALowerB;
global paramAUpperB;
global paramKLowerB;
global paramKUpperB;
global paramAStepSize;
global paramKStepSize;
global numDatasets;

paramALowerB = str2double(get(handles.aInitTxt,'String'));
paramAUpperB = str2double(get(handles.aEndTxt,'String'));
paramKLowerB = str2double(get(handles.kInitTxt,'String'));
paramKUpperB = str2double(get(handles.kEndTxt,'String'));
paramAStepSize = str2double(get(handles.stepSizeATxt,'String'));
paramKStepSize = str2double(get(handles.stepSizeKTxt,'String'));
numDatasets = str2double(get(handles.numDatasetsTxt,'String'));

% --- Outputs from this function are returned to the command line.
function varargout = rfidemo_pest_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function aInitTxt_Callback(hObject, eventdata, handles)
% hObject    handle to aInitTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of aInitTxt as text
%        str2double(get(hObject,'String')) returns contents of aInitTxt as a double
global paramALowerB;

paramALowerB = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function aInitTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to aInitTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function aEndTxt_Callback(hObject, eventdata, handles)
% hObject    handle to aEndTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of aEndTxt as text
%        str2double(get(hObject,'String')) returns contents of aEndTxt as a double

global paramAUpperB;

paramAUpperB = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function aEndTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to aEndTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kInitTxt_Callback(hObject, eventdata, handles)
% hObject    handle to kInitTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kInitTxt as text
%        str2double(get(hObject,'String')) returns contents of kInitTxt as a double
global paramKLowerB;

paramKLowerB = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function kInitTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kInitTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kEndTxt_Callback(hObject, eventdata, handles)
% hObject    handle to kEndTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kEndTxt as text
%        str2double(get(hObject,'String')) returns contents of kEndTxt as a double
global paramKUpperB;

paramKUpperB = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function kEndTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kEndTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function numDatasetsTxt_Callback(hObject, eventdata, handles)
% hObject    handle to numDatasetsTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of numDatasetsTxt as text
%        str2double(get(hObject,'String')) returns contents of numDatasetsTxt as a double
global numDatasets

numDatasets = str2num(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function numDatasetsTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to numDatasetsTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function stepSizeATxt_Callback(hObject, eventdata, handles)
% hObject    handle to stepSizeATxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of stepSizeATxt as text
%        str2double(get(hObject,'String')) returns contents of stepSizeATxt as a double
global paramAStepSize;

paramAStepSize = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function stepSizeATxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to stepSizeATxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function stepSizeKTxt_Callback(hObject, eventdata, handles)
% hObject    handle to stepSizeKTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of stepSizeKTxt as text
%        str2double(get(hObject,'String')) returns contents of stepSizeKTxt as a double
global paramKStepSize;

paramKStepSize = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function stepSizeKTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to stepSizeKTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in stopBtn.
function stopBtn_Callback(hObject, eventdata, handles)
% hObject    handle to stopBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global abort
abort = true;

set(handles.stopBtn,'Enable','off');


% --- Executes on button press in runBtn.
function runBtn_Callback(hObject, eventdata, handles)
% hObject    handle to runBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Add the required PATHS for the function to function :)
addpath(genpath('../'));

global paramALowerB;
global paramAUpperB;
global paramKLowerB;
global paramKUpperB;
global paramAStepSize;
global paramKStepSize;
global numDatasets;
global abort;

% check for valid parameters
isValid = true; errmsg = '';
if ((paramALowerB < 0) || (paramAUpperB > 1))
    isValid = false;
    errmsg = 'Invalid range for A';
elseif( (paramKLowerB < 0) || (paramKUpperB > 1))
    isValid = false;
    errmsg = 'Invalid range for K';
elseif ((paramAStepSize < 0) || (paramAStepSize > paramAUpperB))
    isValid = false;
    errmsg = 'Invalid step size for A';
elseif ((paramKStepSize < 0) || (paramKStepSize > paramKUpperB))
    isValid = false;
    errmsg = 'Invalid step size for K';
elseif (numDatasets <= 0)
    isValid = false;
    errmsg = 'Invalid number of datasets';
end

if (isValid == false)
    edlg = errordlg(errmsg, 'Invalid Parameters','modal');
    return
end

% disable run button
set(hObject,'Enable', 'off');
set(handles.stopBtn,'Enable','on');

set(handles.statusLabel,'String','Running simulation...');

% Defined Paramters
%A = .15; Gamma = 10^-2; 
%N = 1000; MaxVal = 5; M = 10;
N = 100; M = 10;

A = paramALowerB:paramAStepSize:paramAUpperB; 
%A = [10^-2 10^-1 1]; 
K = paramKLowerB:paramKStepSize:paramKUpperB; 
%K = [10^-6:10^-6:10^-5 10^-5+10^-5:10^-5:10^-4 10^-4+10^-4:10^-4:10^-3 10^-3+10^-3:10^-3:10^-2];

A_est_vec = []; K_est_vec = [];
mse_A = []; mse_vec_A = []; mse_K = []; mse_vec_K = [];
mse_avg_A = []; mse_avg_K = [];
num_iter_sample_vec = []; num_iter_vec = [];
numDatasetsProcessed = 0; numProcessedA = 0; numProcessedK = 0;

mseplotK = handles.mseKAxes;
title(mseplotK, 'Sample mean-square relative error as a function of K');
xlabel(mseplotK, 'K');
ylabel(mseplotK, 'MSE = [(Kest - K)/K]^2');

mseplotA = handles.mseAAxes;
title(mseplotA, 'Sample mean-square relative error as a function of A');
xlabel(mseplotA, 'A');
ylabel(mseplotA, 'MSE = [(Aest - A)/A]^2');

iterplot = handles.numIterAxes;
title(iterplot, 'Number of iterations to converge');
xlabel(iterplot, 'K');
ylabel(iterplot, 'Iterations');

abort = false;

for l = 1:length(A)
    numProcessedK = 0;
    for i = 1:length(K)
        refresh(handles.rfidemopestfig);
        %curTxt = get(handles.statusLabel, 'String');
        %set(handles.statusLabel, 'String', strcat(curTxt,(strcat( strcat( strcat('Estimating A, K for A = ', num2str(A(l))), ', K = '),num2str(K(i))))));
        disp(strcat( strcat( strcat('Estimating A, K for A = ', num2str(A(l))), ', K = '),num2str(K(i))));

        refresh(handles.rfidemopestfig);
        pause(1);
        Gamma = K(i) / A(l);

        % Generate Noise 
        [z w] = RFI_MakeDataClassA(A(l), Gamma, N, M);
        % Initial Guess
        A_in = 10^-1; K_in = 10^-4;
        %A_prev = 10; K_prev = 10;
        for j = 1:numDatasets
            refresh(handles.rfidemopestfig);
            pause(1);
            [A_est K_est num_iter_sample] = RFI_EMTwoParamEst(N, M, z, A_in, K_in);
            A_est_vec = [A_est_vec A_est];
            K_est_vec = [K_est_vec K_est];
            num_iter_sample_vec = [num_iter_sample_vec num_iter_sample];
            numDatasetsProcessed = numDatasetsProcessed + 1;
            if (abort == true)
                break;
            end
        end
        mseA = ((A_est_vec - A(l))/A(l)).^2;
        mseA = sum(mseA);
        mseA = mseA / numDatasetsProcessed;
        mse_vec_A = [mse_vec_A mseA];
        mseK = ((K_est_vec - K(i))/K(i)).^2;
        mseK = sum(mseK);
        mseK = mseK / numDatasetsProcessed;
        mse_vec_K = [mse_vec_K mseK];
        num_iter_avg = sum(num_iter_sample_vec) / numDatasetsProcessed;
        num_iter_vec = [num_iter_vec num_iter_avg];
        num_iter_sample_vec = [];
        A_est_vec = [];
        K_est_vec = [];
        numDatasetsProcessed = 0;
        numProcessedK = numProcessedK + 1;
        if (abort == true)
            break;
        end
    end %K loop
    hold(iterplot)
    if (l == 1)
        plot(iterplot, K(1:numProcessedK), num_iter_vec, 'r');
    elseif (l == 2)
        plot(iterplot, K(1:numProcessedK), num_iter_vec, 'b');
    elseif (l == 3)
        plot(iterplot, K(1:numProcessedK), num_iter_vec, 'g');
    else
        plot(iterplot, K(1:numProcessedK), num_iter_vec, 'y');
    end
    set(iterplot, 'XScale', 'log');
    hold(iterplot)
    mse_avg_A = [mse_avg_A sum(mse_vec_A)/numProcessedK];
    mse_vec_A = [];
    if (l == 1) mse_avg_K = mse_vec_K; end; %first iteration, initialize mse_avg_K
    if (numProcessedK == length(K))
        mse_avg_K = (mse_avg_K + mse_vec_K) ./ 2;
    else
        % if we aborted early and haven't finished a whole K iteration yet,
        % use the partial results.
        if (length(mse_avg_K) == 0)
            mse_avg_K = mse_vec_K;
        elseif (l > 1)
            % if we aborted early, but we already finished a whole K iteration,
            % use the unaveraged results.
            numProcessedK = length(K);
        end
    end
            
    mse_vec_K = [];
    num_iter_vec = [];
    numProcessedA = numProcessedA + 1;
    if (abort == true)
            break;
    end
end % A loop

mse_avg_A = mse_avg_A ./ numProcessedA;
mse_avg_K = mse_avg_K ./ numProcessedA;

plot(mseplotK, K(1:numProcessedK), mse_avg_K);
title(mseplotK, 'Sample mean-square relative error as a function of K');
xlabel(mseplotK, 'K');
ylabel(mseplotK, 'MSE = [(Kest - K)/K]^2');
set(mseplotK, 'XScale', 'log');

plot(mseplotA, A(1:numProcessedA), mse_avg_A);
title(mseplotA, 'Sample mean-square relative error as a function of A');
xlabel(mseplotA, 'A');
ylabel(mseplotA, 'MSE = [(Aest - A)/A]^2');
set(mseplotA, 'XScale', 'log');

if (length(A) > 3)
    legend(iterplot, strcat('A = ', num2str(A(1))), strcat('A = ', num2str(A(2))), strcat('A = ', num2str(A(3))));
end

disp('Simulation complete');
disp('MSEs are averaged over the other parameter. (e.g., all MSE(A) averaged over all K)');

set(handles.statusLabel,'String','Simulation complete.');

% re-enable run button
set(hObject,'Enable', 'on');
refresh(handles.rfidemopestfig);
set(handles.stopBtn,'Enable','off');



% --------------------------------------------------------------------
function fileMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to fileMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function exportMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to exportMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[filename, pathname, index] = uiputfile('*.fig', 'Save figure as');

if (index > 0)
    % create an invisible figure to save the files
    % save the axes in the same figure
    saveFig = figure('visible', 'off');
    subplot(3,1,1);
    data = get(handles.numIterAxes, 'Children');
    copyAx = copyobj(data, gca);
    ylabel(gca, get(get(handles.numIterAxes,'YLabel'),'String'));
    xlabel(gca, get(get(handles.numIterAxes,'XLabel'),'String'));
    title(gca, get(get(handles.numIterAxes,'Title'),'String'));
    set(gca, 'XScale', get(handles.numIterAxes,'XScale'));
    
    subplot(3,1,2);
    data = get(handles.mseKAxes, 'Children');
    copyAx = copyobj(data, gca);
    ylabel(gca, get(get(handles.mseKAxes,'YLabel'),'String'));
    xlabel(gca, get(get(handles.mseKAxes,'XLabel'),'String'));
    title(gca, get(get(handles.mseKAxes,'Title'),'String'));
    set(gca, 'XScale', get(handles.mseKAxes,'XScale'));
    
    subplot(3,1,3);
    data = get(handles.mseAAxes, 'Children');
    copyAx = copyobj(data, gca);
    ylabel(gca, get(get(handles.mseAAxes,'YLabel'),'String'));
    xlabel(gca, get(get(handles.mseAAxes,'XLabel'),'String'));
    title(gca, get(get(handles.mseAAxes,'Title'),'String'));
    set(gca, 'XScale', get(handles.mseAAxes,'XScale'));
    
    hgsave(saveFig, strcat(pathname, filename));
    close(saveFig);
end
