% RFI_demo.m is a M-file script that illustrates the usage of the receiver 
% functions given in this release. It produces varoius plots that
% illustrate the communication performance of the receiver.
%
% NOTE: This program may take a long time to finish depending on the
% settings that you use (no_iterations, etc.)
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

addpath(genpath('../'))  %add the directory that contains the required functions

SNR=-20:5:10; %SNR range
err_rate_classA_corr=zeros(1,length(SNR));
err_rate_classA_opt=zeros(1,length(SNR));
err_rate_classA_wiener=zeros(1,length(SNR));

%Simulation Settings
no_bits=10; %number of bits for simulation per iteration
M=2; %number of constellation points (currently only 2 is supported)
N=100; %number of sampled points (raised cosine pulse shape, and received signal)
% NOTE: Please make sure that no_bits x N is less not greater than 10^3,
% otherwise, depending on your machine, you may experience problems with
% the RFI_NoiseSamplesClassA that generates the random noise. To increase
% the number of simulated bits just increase the number of iteration that
% the program runs by modifying the value of the no_iterations variable.

% Pulse Shape Design
y=rcosine(1,5,'default',0.1,10);%Need to be adjusted to fit N (defined above)
%need to choose the right parameters according to the value of N
%the value of N should satisfy N=k*2*delay (see help rcosine)
y=y(1:length(y)-1);

% Wiener Filter Design precalculations (autocorrelation)
y_cor=xcorr(y,'unbiased');
y_cor=y_cor(N:length(y_cor));
Ry=toeplitz(y_cor); % The autocorrelation Matrix of y

% Simulation Part
no_iterations = 100; %Specifies the number of iterations that the code should run
for j=1:no_iterations
    j
    
% generate 100 bits and modulate the signal
[x_pul x_mod ] = RFI_gen_binary_mod(no_bits,2,y);


% Class A noise generation and SNR sweep
A=.35;
T=.5*10^-3;
classA=RFI_NoiseSamplesClassA(A,T,N*no_bits,15); %can be included inside of the loop to provide more
                                                   %randomness at the cost
                                                   %of much more running
                                                   %time
for i=1:length(SNR)
    per=randperm(length(classA));
    classA=classA(per);
    z=classA*sqrt(10^(-SNR(i)/10));  %renormalize the noise for correct SNR
    
    r=x_pul+z(:); % add noise to the signal

    %Wiener Filter Design 
    w=inv(Ry+10^(-SNR(i)/10)*eye(N))*y_cor';%wiener filter coefficients (Solving Wiener-Hopf Equations)

    [dem_bits err_rate_corr] = RFI_detect_cor( r, x_mod, N );
    [dem_bits err_rate_wiener] = RFI_detect_wiener( r, x_mod, N, w );
    [dem_bits err_rate_opt] = RFI_detect_opt( r, x_mod, N, A, T, y );
   
       
    err_rate_classA_corr(i)= err_rate_classA_corr(i)+err_rate_corr;
    err_rate_classA_opt(i)=err_rate_classA_opt(i)+err_rate_opt;
    err_rate_classA_wiener(i)=err_rate_classA_wiener(i)+err_rate_wiener;
end;

end;

err_rate_classA_corr=err_rate_classA_corr/no_iterations;
err_rate_classA_opt=err_rate_classA_opt/no_iterations;
err_rate_classA_wiener=err_rate_classA_wiener/no_iterations;

plot(SNR,err_rate_classA_corr, SNR, err_rate_classA_opt, SNR, err_rate_classA_wiener);
xlabel('SNR');ylabel('BER');
title('Communication Performance');
legend('Correlation Receiver','Bayesian Detection', 'Wiener Filtering');
