function varargout = rfidemo(varargin)
% RFIDEMO M-file for rfidemo.fig
%      RFIDEMO, by itself, creates a new RFIDEMO or raises the existing
%      singleton*.
%
%      H = RFIDEMO returns the handle to a new RFIDEMO or the handle to
%      the existing singleton*.
%
%      RFIDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFIDEMO.M with the given input arguments.
%
%      RFIDEMO('Property','Value',...) creates a new RFIDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rfidemo_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rfidemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help rfidemo

% Last Modified by GUIDE v2.5 07-May-2007 23:20:16

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rfidemo_OpeningFcn, ...
                   'gui_OutputFcn',  @rfidemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rfidemo is made visible.
function rfidemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rfidemo (see VARARGIN)

% Choose default command line output for rfidemo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rfidemo wait for user response (see UIRESUME)
% uiwait(handles.rfidemofig);

% initialize state variables
global numSymToSend;
global numSamplesPerSym;
global SNR;
global useClassA;
    global aParam; global kParam;
global useAlphaStable;
    global alphaParam;
    global dispParam;
    global deltaParam;
global useWiener;
global useDetection;

% defaults
useClassA = true;
useAlphaStable = false;
useWiener = false;
useDetection = false;
aParam = 0;
kParam = 0;
alphaParam = 0;
dispParam = 0;
deltaParam = 0;
numSamplesPerSym = -1;
numSymToSend = -1;
SNR = 0;

% --- Outputs from this function are returned to the command line.
function varargout = rfidemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

function numSymTxt_Callback(hObject, eventdata, handles)
% hObject    handle to numSymTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of numSymTxt as text
%        str2double(get(hObject,'String')) returns contents of numSymTxt
%        as a double
global numSymToSend
numSymToSend = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function numSymTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to numSymTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function numSamplesPerSymbolTxt_Callback(hObject, eventdata, handles)
% hObject    handle to numSamplesPerSymbolTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of numSamplesPerSymbolTxt as text
%        str2double(get(hObject,'String')) returns contents of numSamplesPerSymbolTxt as a double
global numSamplesPerSym
numSamplesPerSym = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function numSamplesPerSymbolTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to numSamplesPerSymbolTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function snrTxt_Callback(hObject, eventdata, handles)
% hObject    handle to snrTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of snrTxt as text
%        str2double(get(hObject,'String')) returns contents of snrTxt as a double
global SNR
SNR = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function snrTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to snrTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in wienerChk.
function wienerChk_Callback(hObject, eventdata, handles)
% hObject    handle to wienerChk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of wienerChk
global useWiener
useWiener = get(hObject,'Value');

% --- Executes on button press in detectionChk.
function detectionChk_Callback(hObject, eventdata, handles)
% hObject    handle to detectionChk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of detectionChk
global useDetection
useDetection = get(hObject, 'Value');

% --- Executes on button press in useClassABtn.
function useClassABtn_Callback(hObject, eventdata, handles)
% hObject    handle to useClassABtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of useClassABtn
global useClassA
global useAlphaStable

useClassA = true;
useAlphaStable = false;

% make class A parameters visible, all others invisible
set(handles.aParamLabel, 'Visible', 'on');
set(handles.aParamTxt, 'Visible', 'on');
set(handles.kParamLabel, 'Visible', 'on');
set(handles.kParamTxt, 'Visible', 'on');
set(handles.alphaParamLabel, 'Visible', 'off');
set(handles.alphaParamTxt, 'Visible', 'off');
set(handles.dispParamLabel, 'Visible', 'off');
set(handles.dispParamTxt, 'Visible', 'off');
set(handles.deltaParamLabel, 'Visible', 'off');
set(handles.deltaParamTxt, 'Visible', 'off');

% --- Executes on button press in useAlphaBtn.
function useAlphaBtn_Callback(hObject, eventdata, handles)
% hObject    handle to useAlphaBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of useAlphaBtn
global useAlphaStable
global useClassA

useAlphaStable = true;
useClassA = false;

% make class A parameters visible, all others invisible
set(handles.alphaParamLabel, 'Visible', 'on');
set(handles.alphaParamTxt, 'Visible', 'on');
set(handles.dispParamLabel, 'Visible', 'on');
set(handles.dispParamTxt, 'Visible', 'on');
set(handles.deltaParamLabel, 'Visible', 'on');
set(handles.deltaParamTxt, 'Visible', 'on');
set(handles.aParamLabel, 'Visible', 'off');
set(handles.aParamTxt, 'Visible', 'off');
set(handles.kParamLabel, 'Visible', 'off');
set(handles.kParamTxt, 'Visible', 'off');

function aParamTxt_Callback(hObject, eventdata, handles)
% hObject    handle to aParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of aParamTxt as text
%        str2double(get(hObject,'String')) returns contents of aParamTxt as a double
global aParam
aParam = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function aParamTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to aParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function kParamTxt_Callback(hObject, eventdata, handles)
% hObject    handle to kParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kParamTxt as text
%        str2double(get(hObject,'String')) returns contents of kParamTxt as a double
global kParam
kParam = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function kParamTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function alphaParamTxt_Callback(hObject, eventdata, handles)
% hObject    handle to alphaParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of alphaParamTxt as text
%        str2double(get(hObject,'String')) returns contents of alphaParamTxt as a double
global alphaParam
alphaParam = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function alphaParamTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to alphaParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function dispParamTxt_Callback(hObject, eventdata, handles)
% hObject    handle to dispParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of dispParamTxt as text
%        str2double(get(hObject,'String')) returns contents of dispParamTxt as a double
global dispParam
dispParam = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function dispParamTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dispParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function deltaParamTxt_Callback(hObject, eventdata, handles)
% hObject    handle to deltaParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of localParamTxt as text
%        str2double(get(hObject,'String')) returns contents of localParamTxt as a double
global deltaParam
deltaParam = str2double(get(hObject,'String'));


% --- Executes during object creation, after setting all properties.
function deltaParamTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to deltaParamTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in runBtn.
function runBtn_Callback(hObject, eventdata, handles)
% hObject    handle to runBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Add the required PATHS for the function to function :)
addpath(genpath('../'));

% recall global vars
global numSymToSend;
global numSamplesPerSym;
global SNR;
global useClassA;
    global aParam; global kParam;
global useAlphaStable;
    global alphaParam;
    global dispParam;
    global deltaParam;
global useWiener;
global useDetection;

global rh; %figure handle

A_lowerb = 10^-2;
A_upperb = 1;
K_lowerb = 10^-6;
K_upperb = 1;

BLOCK_SIZE = 1000;

% check for a valid set of options
isValid = true; errmsg = '';
if (numSymToSend < 0)
%if (~exist('numBytesToSend') || (numBytesToSend < 0))
    isValid = false;
    errmsg = 'Not enough bytes to send';
%elseif( SNR <= 0)
%    isValid = false;
%    errmsg = 'Invalid SNR';
elseif(numSamplesPerSym < 0)
    isValid = false;
    errmsg = 'Not enough samples per symbol';
elseif (~useClassA) && (~useAlphaStable)
    isValid = false;
    errmsg = 'No noise type selected';
%elseif ((useClassA == true) && ((~exist('paramA') || (~exist('paramK')))))
elseif ((useClassA == true) && ( ((aParam < A_lowerb) || (aParam > A_upperb)) || ((kParam < K_lowerb) || (kParam > K_upperb))))
    isValid = false;
    errmsg = 'Invalid Class A parameters';
%elseif ((useAlphaStable == true) && (~exist('alpha')))
elseif ((useAlphaStable == true) && (alphaParam < 0))
    isValid = false;
    errmsg = 'Invalid Alpha Stable parameters';
end

if (isValid == false)
    edlg = errordlg(errmsg, 'Invalid Parameters','modal');
    return
end

% disable run button so it can't be pressed again while we compute
set(hObject,'Enable', 'off');
refresh(handles.rfidemofig);
pause(1);

% close the old results window, if it is still open
if exist('rh')
    if ishandle(rh) close(rh); end;
end

disp('Simulating...');

% do the computations, then pass the result panel the vectors to plot

% generate noise envelope for parameter estimate
[z z_env M] = generate_noise(kParam, aParam, useClassA, alphaParam, dispParam, deltaParam, useAlphaStable, SNR);
z_orig = z;
        
% make pulse shape for transmitted signal
numConstellationPoints = 2; %constellation size
delay = 5;
trans_pulse=rcosine(1,numSamplesPerSym,'default',0.1,delay);%Need to be adjusted to fit N
%need to choose the right parameters acording to the value of N
trans_pulse=trans_pulse(1:length(trans_pulse)-1);

%symbols*samples/sym*2*delay*num_bits/sym
N = numSymToSend*numSamplesPerSym*2*delay*2;

% generate Wiener filter ahead of time
Ns = numSamplesPerSym*2*delay;
if (useWiener)
    w = make_wiener_filter(Ns, trans_pulse, SNR);
end

% initialize
A_est_total = 0; K_est_total = 0; delta_est_total = 0; alpha_est_total = 0; disper_est_total = 0;
err_rate_wiener_total = 0; err_rate_corr_total = 0; err_rate_opt_total = 0; num_iter_total = 0;


%---------- EXECUTE N / BLOCK_SIZE TIMES ----------%

last = ceil(N / BLOCK_SIZE);
disp(strcat(num2str(last), '  blocks total.'));
TOTAL_N = N; 
for i=1:last
    disp(strcat('Now processing block... ', num2str(i)));
    Ni = TOTAL_N;
    if (Ni > BLOCK_SIZE)
        Ni = BLOCK_SIZE;
        TOTAL_N = TOTAL_N - BLOCK_SIZE;
    end
    
    % generate signal
    NUM_BITS = Ni/(numSamplesPerSym*2*delay);
    modType = get(handles.qam4Btn, 'Value');
    if (modType == 1) % 4QAM
        % generate a pseudo-random bit stream
        x = randint(NUM_BITS, 1);
        ytx = rfi4qam(x);
    elseif (modType == 0) % 2PAM
        [ytx x_mod] = RFI_gen_binary_mod(NUM_BITS,numConstellationPoints,trans_pulse);
    end

    % add Noise
    if (useClassA) || (useAlphaStable)
        % keep selecting randomly from the block z up to Ni noise samples
        while(length(z) < Ni)
            z = cat(2, z, z(randperm(length(z))));
            z_env = cat(2, z_env, z_env(randperm(length(z_env))));
        end
        if (length(z) > Ni)
            z = z(randperm(Ni));
            if (useClassA)
                z_env = z_env(randperm(Ni));
            end
        end
        z=z*sqrt(10^(-SNR/10));
        y_dirty=ytx+z(:); % add noise to the signal
    else
        y_dirty=ytx;
    end
    %figure;
    %plot(y_dirty);
    %title('Transmitted QAM signal after Class A noise');

    % receiver
    
    % estimate parameters
    if (useClassA)
        % Initial Guess
        A = 10^-1; K = 10^-4;
        [A_est K_est numIter] = RFI_EMTwoParamEst(Ni, M, z_env, A, K);
        A_est_total = A_est_total + A_est / 2;
        K_est_total = K_est_total + K_est / 2;
        num_iter_total = num_iter_total + numIter / 2;
    elseif (useAlphaStable)
        delta_est = RFI_EstAlphaS_Localization(z_orig); % Location Parameter Estimate
        L = 1250; % Characteristic exponential estimate
        alpha_est = RFI_EstAlphaS_Alpha(z_orig, L, delta_est);
        disper_est = RFI_EstAlphaS_Dispersion(z_orig, alpha_est, delta_est);
        delta_est_total = delta_est_total + delta_est / 2;
        alpha_est_total = alpha_est_total + alpha_est / 2;
        disper_est_total = disper_est_total + disper_est / 2;
    end

    Ns = 2*delay*numSamplesPerSym;
    if (useWiener)
        % clear filter memory
        reset_wiener_filter(w);
        [dem_bits err_rate_wiener] = RFI_detect_wiener( y_dirty, x_mod, Ns, w );
        err_rate_wiener_total = err_rate_wiener_total + err_rate_wiener / 2;
    end
    if (useDetection)
        [dem_bits err_rate_corr] = RFI_detect_cor( y_dirty, x_mod, Ns );
        err_rate_corr_total = err_rate_corr_total + err_rate_corr / 2;
        if (useClassA)
            [dem_bits err_rate_opt] = RFI_detect_opt( y_dirty, x_mod, Ns, A_est, K_est/A_est, trans_pulse );
            err_rate_opt_total = err_rate_opt_total + err_rate_opt / 2;
        end
    end
end

%------------- ALL BLOCKS FINISHED ------------%

if (useClassA)
    delta_est_total = -1;
    alpha_est_total = -1;
    disper_est_total = -1;
elseif (useAlphaStable)
    A_est_total = -1;
    K_est_total = -1;
    err_rate_opt_total = -1;
end

if (useWiener == false)
    err_rate_wiener_total = -1;
end
if (useDetection == false)
    err_rate_corr_total = -1;
    err_rate_opt_total = -1;
end


param_ests = [A_est_total K_est_total alpha_est_total disper_est_total delta_est_total];
bit_error_rates = [err_rate_wiener_total err_rate_corr_total err_rate_opt_total];

rh = rfidemo_results(y_dirty, z, param_ests, bit_error_rates);

% re-enable run button
set(hObject,'Enable', 'on');
refresh(handles.rfidemofig);



%------------------- HELPER FUNCTIONS -------------------%


function w = make_wiener_filter(N, trans_pulse, SNR)
    %% Wiener Filter Design
    trans_pulse_cor=xcorr(trans_pulse,'unbiased');
    trans_pulse_cor=trans_pulse_cor(N:length(trans_pulse_cor));
    R=toeplitz(trans_pulse_cor);
    w=inv(R+10^(-SNR/10)*eye(N))*trans_pulse_cor';%wiener filter coefficients


function reset_wiener_filter(w)
    empty = zeros(length(w));
    filter(w, 1, empty);

function [z z_env M] = generate_noise(kParam, aParam, useClassA, alphaParam, dispParam, deltaParam, useAlphaStable, SNR)
    z = []; z_env = [];
    NOISE_BLOCK_SIZE = 100;
    
    if (useClassA == true)
        M = 10;
        MaxVal = 15;
        Gamma = kParam / aParam;
        [z_env w]= RFI_MakeDataClassA(aParam, Gamma, NOISE_BLOCK_SIZE, MaxVal);
    elseif (useAlphaStable == true)
        M = 100; MaxVal = 50;
        [pdf z] = RFI_MakeDataAlphaStable(alphaParam, dispParam, deltaParam, 100*NOISE_BLOCK_SIZE, M, MaxVal);
    end

    % generate noise vector
    if (useClassA == true)
        Gamma = kParam / aParam;
        z = RFI_NoiseSamplesClassA(aParam, Gamma, NOISE_BLOCK_SIZE, MaxVal);
        z = z * sqrt(10^(-SNR/10));
    end
