function varargout = rfidemo_rx2(varargin)
% RFIDEMO_RX2 M-file for rfidemo_rx2.fig
%      RFIDEMO_RX2, by itself, creates a new RFIDEMO_RX2 or raises the existing
%      singleton*.
%
%      H = RFIDEMO_RX2 returns the handle to a new RFIDEMO_RX2 or the handle to
%      the existing singleton*.
%
%      RFIDEMO_RX2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFIDEMO_RX2.M with the given input arguments.
%
%      RFIDEMO_RX2('Property','Value',...) creates a new RFIDEMO_RX2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rfidemo_rx2_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rfidemo_rx2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help rfidemo_rx2

% Last Modified by GUIDE v2.5 11-Jul-2007 20:18:58

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rfidemo_rx2_OpeningFcn, ...
                   'gui_OutputFcn',  @rfidemo_rx2_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rfidemo_rx2 is made visible.
function rfidemo_rx2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rfidemo_rx2 (see VARARGIN)

addpath(genpath('../'))  %add the directory that contians the required functions

% Choose default command line output for rfidemo_rx2
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rfidemo_rx2 wait for user response (see UIRESUME)
% uiwait(handles.figure1);

ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(ESPL_logo);
%axis equal;
%axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');

WNCG_logo=imread('wncg-sm.jpg');
set(handles.WNCG_logo,'HandleVisibility','ON');
axes(handles.WNCG_logo);
image(WNCG_logo);
axis equal;
axis tight;
axis off;
set(handles.WNCG_logo,'HandleVisibility','OFF');

% --- Outputs from this function are returned to the command line.
function varargout = rfidemo_rx2_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double


% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function bits_per_itr_Callback(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bits_per_itr as text
%        str2double(get(hObject,'String')) returns contents of bits_per_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end


% --- Executes during object creation, after setting all properties.
function bits_per_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function no_itr_Callback(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of no_itr as text
%        str2double(get(hObject,'String')) returns contents of no_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if (isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function no_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_low_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_low_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_low_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_low_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','-20');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
high_limit = str2double(get(handles.SNRrange_high_limit, 'String'));
if (user_entry > high_limit)
    set(hObject, 'String', num2str(high_limit-30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_low_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_low_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_high_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_high_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_high_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
lower_limit = str2double(get(handles.SNRrange_low_limit, 'String'));
if (user_entry < lower_limit)
    set(hObject, 'String', num2str(lower_limit+30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_high_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNR_step_size_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_step_size as text
%        str2double(get(hObject,'String')) returns contents of SNR_step_size as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_step_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function A_Callback(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A as text
%        str2double(get(hObject,'String')) returns contents of A as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.35');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-2)
    set(hObject,'String','0.35');
    errordlg('A range exceeded. A should belong to [0.01,1].','Bad Input','modal')
end;
    

% --- Executes during object creation, after setting all properties.
function A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gamma as text
%        str2double(get(hObject,'String')) returns contents of Gamma as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.001');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-6)
    set(hObject,'String','0.001');
    errordlg('Gamma range exceeded. Gamma should belong to [10^-6,1].','Bad Input','modal')
end;

% --- Executes during object creation, after setting all properties.
function Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_Callback(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r as text
%        str2double(get(hObject,'String')) returns contents of r as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.1');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry < 0 | user_entry > 1)
    set(hObject,'String','0.1');
    errordlg('Invalid value for r. r should be between 0 and 1.','Bad Input','modal');
end;



% --- Executes during object creation, after setting all properties.
function r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delay_Callback(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delay as text
%        str2double(get(hObject,'String')) returns contents of delay as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a postive numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function delay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function sampling_ratio_Callback(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sampling_ratio as text
%        str2double(get(hObject,'String')) returns contents of sampling_ratio as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function sampling_ratio_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in corr_rx.
function corr_rx_Callback(hObject, eventdata, handles)
% hObject    handle to corr_rx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of corr_rx


% --- Executes on button press in wiener_dtc.
function wiener_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to wiener_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of wiener_dtc


% --- Executes on button press in bayesian_dtc.
function bayesian_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to bayesian_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bayesian_dtc


% --- Executes on button press in start_sim.
function start_sim_Callback(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% The UserData is being used to indicate if the button is in the Start mode
% (0) or the Stop mode (1)
% if (get(hObject, 'UserData') == 0)
%     set(hObject,'String','Stop Simulation');
%     set(hObject,'UserData',1);
% else
%     % Add ending code sequence here depending on the desired ending
%     % behavior
%     set(hObject,'String','Start Simulation');
%     set(hObject,'UserData',0);
%     return;
% end;
%Temporary button disbale functionality
set(hObject,'enable','inactive');
% Obtain necessary data from the GUI handles structure, I chose to get them
% rather than store then in the handles strucuture using guidata becuase
% the amount of data is small and this saves a lot of work in updating the
% fields and save some memory space
corr_status = get(handles.corr_rx, 'Value');
wiener_status = get(handles.wiener_dtc, 'Value');
bayes_status = get(handles.bayesian_dtc, 'Value');
% Get Class A parameters
A = str2double(get(handles.A, 'String')); 
T = str2double(get(handles.Gamma, 'String'));
SNR_low_limit = str2double(get(handles.SNRrange_low_limit, 'String'));
SNR_high_limit = str2double(get(handles.SNRrange_high_limit, 'String'));
step_size = str2double(get(handles.SNR_step_size, 'String'));

if (corr_status + wiener_status + bayes_status == 0)
    errordlg('Please select at least one detection method.','Irrational Settings','modal')
    set(hObject,'String','Start Simulation');
    set(hObject,'UserData',0);
    return;
end;

SNR=SNR_low_limit:step_size:SNR_high_limit; %SNR range
err_rate_classA_corr=zeros(1,length(SNR));
err_rate_classA_opt=zeros(1,length(SNR));
err_rate_classA_wiener=zeros(1,length(SNR));

no_bits = str2double(get(handles.bits_per_itr, 'String')); %number of bits for simulation per iteration
no_iterations = str2double(get(handles.no_itr, 'String')); %number of iterations
M=2; %number of constellation points (currently only 2 is supported)
delay = str2double(get(handles.delay, 'String')); %delay of the raised cosine filter
sampling_ratio = str2double(get(handles.sampling_ratio, 'String')); %the sampling ratio for the raised cosine filter
r = str2double(get(handles.r, 'String')); % r for the raised cosing filter
N=2*delay*sampling_ratio; %number of sampled points (raised cosine pulse shape, and received signal)

% Pulse Shape Design
y=rcosine(1,sampling_ratio,'default',r,delay);%Need to be adjusted to fit N (defined above)
%need to choose the right parameters acording to the value of N
%the value of N should satisfy N=k*2*delay (see help rcosine)
y=y(1:length(y)-1);

% Wiener Filter Design precalculations (autocorrelation)
if (wiener_status == 1)
    y_cor=xcorr(y,'unbiased');
    y_cor=y_cor(N:length(y_cor));
    Ry=toeplitz(y_cor); % The autocorrelation Matrix of y
end;

for j=1:no_iterations

% generate no_bits bits and modulate the signal
[x_pul x_mod ] = RFI_gen_binary_mod(no_bits,2,y);

% Class A noise generation and SNR sweep
classA=RFI_NoiseSamplesClassA(A,T,N*no_bits,15); %can be included inside of the loop to provide more
                                                 %randomness at the cost
                                                 %of much more running
                                                 %time
for i=1:length(SNR)
    per=randperm(length(classA));
    classA=classA(per);
    z=classA*sqrt(10^(-SNR(i)/10));  %renormalize the noise for correct SNR
    
    r=x_pul+z(:); % add noise to the signal

    %Winer Filter Design
    if (wiener_status == 1)
        w=inv(Ry+10^(-SNR(i)/10)*eye(N))*y_cor';%wiener filter coefficients (Solving Wiener-Hopf Equations)
    end;

    if (corr_status == 1)
        [dem_bits err_rate_corr] = RFI_detect_cor( r, x_mod, N );
        err_rate_classA_corr(i)= err_rate_classA_corr(i)+err_rate_corr;
    end;
    
    if (wiener_status == 1)
        [dem_bits err_rate_wiener] = RFI_detect_wiener( r, x_mod, N, w );
        err_rate_classA_wiener(i)=err_rate_classA_wiener(i)+err_rate_wiener;
    end;
    
    if (bayes_status == 1)
        [dem_bits err_rate_opt] = RFI_detect_opt( r, x_mod, N, A, T, y );
        err_rate_classA_opt(i)=err_rate_classA_opt(i)+err_rate_opt;
    end;
   
end;

end;

figure;
hold on;
xlabel('SNR');ylabel('BER');
title('Comunnication Performance');

if (corr_status == 1)
    err_rate_classA_corr=err_rate_classA_corr/no_iterations;
    plot(SNR,err_rate_classA_corr, 'Displayname', 'Correlation Receiver');
end;
    
if (wiener_status == 1)
    err_rate_classA_wiener=err_rate_classA_wiener/no_iterations;
    plot(SNR, err_rate_classA_wiener,'r','Displayname', 'Wiener Filtering');
end;
    
if (bayes_status == 1)
    err_rate_classA_opt=err_rate_classA_opt/no_iterations;
    plot(SNR, err_rate_classA_opt,'g','Displayname', 'Bayesian Detection');
end;

legend('show');
set(hObject,'enable','on');

% --- Executes on key press over start_sim with no controls selected.
function start_sim_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


