function pdf = RFI_ClassApdf( A, Gamma, N_T, x )
%pdf = RFI_ClassApdf( A, Gamma, N_T, x );
%This function evaluates the pdf of class A noise at a vector of values x.
% Inputs:   A  - overlap index (in general belongs to [10^-2,1])
%           Gamma - ratio of the intensity of the independent Gaussian
%                   component to the intensity of the impulsive non-Gaussian
%                   component (in general belongs to [10^-6,1])
%           N_T  - the number of retained terms of the infinite series
%                  after truncation
%           x     - vector of values where the pdf of Class A noise is to
%                   be evaluated
% Outputs:  pdf    - vector of same size as x containing the PDF of 
%                    Class A interference calculated at the values given in x
%
% Reference:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)


pdf=0;

%Evaluate the pdf based on Eq. 7 in [1]
for i=0:N_T
    sigma = (i/A + Gamma)/(1+Gamma);
    pdf = pdf + (A^i)/(factorial(i)*sqrt(sigma))*exp(-x.^2/(2*sigma));
end;
pdf = pdf*exp(-A)/sqrt(2*pi);