function disper_est = RFI_EstAlphaS_Dispersion(noise_data, alpha_est, delta_est)
% [disper_est] = RFI_EstAlphaS_Dispersion(noise_data, alpha_est, delta_est) 
% Estimates the dispersion parameter of the symmetric alpha stable model using the
% method of extreme order statistics as described in [1]
% Inputs:  noise_data - Vector of symmetric alpha stable noise
%          alpha_est  - Estimate of the characteristic exponent of the
%                      symmetric alpha stable model
%          delta_est  - Estimate of the localization parameter of the
%                      symmetric alpha stable model
%          
% Outputs: disper_est - Estimate of the dispersion parameter of the
%                       symmetric alpha stable model
%
% References:
% [1] G. A. Tsihrintzis and C. L. Nikias, "Fast estimation of the
%     parameters of alpha-stable impulsive interference", IEEE Transactions 
%     on Signal Processing, vol. 44, no 6, pp. 1492-1503, June 1996.
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Arvind Sujeeth (arvind.sujeeth@mail.utexas.edu) 

p = alpha_est/3;
C = 1/cos(pi/2*p) * gamma(1-p/alpha_est) / gamma(1-p) ; % Equation (2-10) in [1]

disper_est = ((sum((abs(noise_data - delta_est)).^p)) / length(noise_data) / C )^(1/p); % As per equation (2-9) in [1]
return;
