function varargout = rfidemo_results(varargin)
% RFIDEMO_RESULTS M-file for rfidemo_results.fig
%      RFIDEMO_RESULTS, by itself, creates a new RFIDEMO_RESULTS or raises the existing
%      singleton*.
%
%      H = RFIDEMO_RESULTS returns the handle to a new RFIDEMO_RESULTS or the handle to
%      the existing singleton*.
%
%      RFIDEMO_RESULTS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFIDEMO_RESULTS.M with the given input arguments.
%
%      RFIDEMO_RESULTS('Property','Value',...) creates a new RFIDEMO_RESULTS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rfidemo_results_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rfidemo_results_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help rfidemo_results

% Last Modified by GUIDE v2.5 08-May-2007 21:17:58

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rfidemo_results_OpeningFcn, ...
                   'gui_OutputFcn',  @rfidemo_results_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rfidemo_results is made visible.
function rfidemo_results_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rfidemo_results (see VARARGIN)

% Choose default command line output for rfidemo_results
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rfidemo_results wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% plot available results

sigAx = handles.sigAxes;
y_dirty  = varargin{1};
plot(sigAx, y_dirty);
ylabel(sigAx, 'Amplitude')
xlabel(sigAx, 'Time')
title(sigAx, 'Transmitted QAM signal with noise');

npsdAx = handles.npsdAxes;
z = varargin{2};
h = spectrum.welch;
z_psd = psd(h,z);
axes(npsdAx);
plot(z_psd);
%plot(npsdAx, z_psd);
%ylabel(npsdAx, 'Power Spectrum Magnitude (dB)');
%xlabel(npsdAx, 'Frequency (Hz)');
%title(npsdAx, 'Power Spectral Density of Noise');

% fill in text labels
param_est = varargin{3};
if (length(param_est) > 0)
    if (param_est(1) > -1) && (param_est(2) > -1)
        set(handles.aParamEstTxt, 'String', strcat('A:  ', num2str(param_est(1))));
        set(handles.aParamEstTxt, 'Visible', 'on');
        set(handles.kParamEstTxt, 'String', strcat('K:  ', num2str(param_est(2))));
        set(handles.kParamEstTxt, 'Visible', 'on');
    end
    if (param_est(3) > -1) && (param_est(4) > -1) && (param_est(5) > -1)
        set(handles.alphaParamEstTxt, 'String', strcat('Alpha:  ', num2str(param_est(3))));
        set(handles.alphaParamEstTxt, 'Visible', 'on');
        set(handles.dispParamEstTxt, 'String', strcat('Dispersion:  ', num2str(param_est(4))));
        set(handles.dispParamEstTxt, 'Visible', 'on');
        set(handles.deltaParamEstTxt, 'String', strcat('Delta:  ', num2str(param_est(5))));
        set(handles.deltaParamEstTxt, 'Visible', 'on');
    end
end

bit_errors = varargin{4};
if (length(bit_errors) > 0)
    if (bit_errors(1) > -1)
        set(handles.biterrorWienerTxt, 'String', num2str(bit_errors(1)));
    else
        set(handles.biterrorWienerTxt, 'String', 'Wiener filtering not selected.');
    end
    if (bit_errors(2) > -1)
        set(handles.biterrorCorrTxt, 'String', num2str(bit_errors(2)));
    else
        set(handles.biterrorCorrTxt, 'String', 'Correlation detection not selected.');
    end
    if (bit_errors(3) > -1)
        set(handles.biterrorOptTxt, 'String', num2str(bit_errors(3)));
    else
        set(handles.biterrorOptTxt, 'String', 'Optimal detection not selected.');
    end
end

% --- Outputs from this function are returned to the command line.
function varargout = rfidemo_results_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --------------------------------------------------------------------
function fileMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to fileMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% --------------------------------------------------------------------
function exportMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to exportMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


[filename, pathname, index] = uiputfile('*.fig', 'Save figure as');

if (index > 0)
    % create an invisible figure to save the files
    % save the axes in the same figure
    saveFig = figure('visible', 'off');
    subplot(2,1,1);
    data = get(handles.sigAxes, 'Children');
    copyAx = copyobj(data, gca);
    ylabel(gca, get(get(handles.sigAxes,'YLabel'),'String'));
    xlabel(gca, get(get(handles.sigAxes,'XLabel'),'String'));
    title(gca, get(get(handles.sigAxes,'Title'),'String'));
    
    subplot(2,1,2);
    data = get(handles.npsdAxes, 'Children');
    copyAx = copyobj(data, gca);
    ylabel(gca, get(get(handles.npsdAxes,'YLabel'),'String'));
    xlabel(gca, get(get(handles.npsdAxes,'XLabel'),'String'));
    title(gca, get(get(handles.npsdAxes,'Title'),'String'));
    
    hgsave(saveFig, strcat(pathname, filename));
    close(saveFig);
end
