function pdf = RFI_ClassApdf( A, Gamma, N_T, x )
%pdf = RFI_ClassApdf( A, Gamma, N_T, x );
%This function evaluates the pdf of class A noise at a vector of values x.
% Inputs:   A  - overlap index (in general belongs to [10^-2,1])
%           Gamma - ratio of the intensity of the independent Gaussian
%                   component to the intensity of the impulsive non-Gaussian
%                   component (in general belongs to [10^-6,1])
%           N_T  - the number of retained terms of the infinite series
%                  after truncation
%           x     - vector of values where the pdf of Class A noise is to
%                   be evaluated
% Outputs:  pdf    - vector of same size as x containing the PDF of 
%                    Class A interference calculated at the values given in x
%
% Reference:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)
%
% Revision history:
% 
% v 1.0: nassar -- initial implementation
% v 1.1beta: nassar (11/22/2007) -- recursive implementation that improves
%                                   perfomance and increases the range of usable As
%

pdf=0;
A_over_m = 1; % improve performance and range of usable A
sigma_sq_prime = A*Gamma; % This variable is sigma_sq * (1+gamma), this is done to induce recursion also on 
                        % sigma
x=x*sqrt((1+Gamma)*A); % This is to enable us to use the new modified variable defined above in the exponential of
                   % the recursion
%Evaluate the pdf based on Eq. 7 in [1]
for i=1:N_T
    pdf = pdf + (A_over_m/sqrt(sigma_sq_prime))*exp(-x.^2/(2*sigma_sq_prime));
    A_over_m = A_over_m * A/i; %improves performance and extends the range of A by recursive implementation.
    sigma_sq_prime = sigma_sq_prime + 1;
end;
pdf = pdf*exp(-A)/sqrt(2*pi/((1+Gamma)*A));