function noise_data = RFI_NoiseSamplesClassA (A, Gamma, N, MaxVal)
%[z w] = RFI_NoiseSamplesClassA (A, Gamma, N, MaxVal, SNR);
%This function generates a vector of synthetic data samples of unit second moment 
%that follow the Class A Middleton Noise model.
% Inputs:   A  - overlap index (in general belongs to [10^-2,1])
%           Gamma - ratio of the intensity of the independent Gaussian
%                   component to the intensity of the impulsive non-Gaussian
%                   component (in general belongs to [10^-6,1])
%           N      - No of samples to be generated. For efficiency of
%                    calculations do not make N greater than 10^3.
%           MaxVal - Data is generated between the interval [-MaxVal, MaxVal]
%                    MaxVal should be chosen such that the pdf at that
%                    value is almost zero.
% Outputs:  noise_data - N length vector of noise data generated based on
%                        the Class A Middleton Noise model with the given
%                        parameters
%
%References:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
% [2] D. Middleton, Non-Gaussian noise models in signal processing
%     for telecommunications: New methods and results for Class A and Class B 
%     noise models, IEEE Transactions on Information Theory, vol. 45, no. 4, 
%     pp. 1129-1149, May 1999.
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Marcel Nassar (nassar@ece.utexas.edu)
%              Marcus DeYoung (deyoung@ece.utexas.edu)
% Revisions:
% v 1.0 gulati -- original RFI_NoiseSamplesClassA
% v 1.1beta nassar (11/22/2007) -- removed the old implementation, and made
% this function just an encapsulation for RFI_makeScalarPDFClassA and
% RFI_makeScalarNoiseClassA_pdf (written by DeYoung) to improve
% computational performance.
%
%
% NOTE: This function is just an encapsulation of two functions that do the
% actual computations. Since the implementation of this function has drastically
% changed resulting in speedups in the order of magnitude, this encapsulation 
% provides a layer of abstraction of the implementation change from the rest 
% of the toolbox.


[thePDF, x] = RFI_makeScalarPDFClassA(A, Gamma, 2000, MaxVal);
% Note: Good values for NumPDF (here set to 2000) are on the order of 1000-2000 
% with MaxVal ~ 10-15.   
noise_data = RFI_makeScalarNoiseClassA_pdf(thePDF, x, N);