function [dem_bits err_rate_corr] = RFI_detect_cor( corrupted_signal, trans_bits, N )
%[dem_bits err_rate_corr] = RFI_detect_cor( corrupted_signal, trans_bits,N);
%This function demodulates the signal using a correlator receiver for the 
%binary digital signaling like 2 PAM, etc. It assumes that the constellation 
%is symmetric with respect to zero.
% Inputs:   corrupted_signal    - the transmitted signal corrupted by noise
%           transmitted_bits     - the vector of transmitted bits
%           N                   - number of samples per symbol
% Outputs:  dem_bits            - vector of demodulated bits
%           err_rate_corr       - the bit error rate using correlation receiver
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

no_symb = length(corrupted_signal)/N;
corrupted_signal=reshape(corrupted_signal,N,no_symb);
r_d=sum(corrupted_signal);
dem_bits = sign(r_d); %correlation receiver when no ISI, 2PAM (optimal for Gaussian)

err_rate_corr = sum(dem_bits~=trans_bits)/no_symb;