function [x_pul x_mod] = RFI_gen_binary_mod( no_bits, M, y)
%[x_pul x_mod] = RFI_gen_binary_mod( no_bits, M, k, delay, y);
%This function generates a sampled signal of a modulated 2 pam signal with
%a raised cosine pulse shape (bits are not intermixed so we dont have any
%ISI)
% Inputs:   no_bits  - the number of bits your file will generate
%           M - the number of constellation point, use 2
%           y     - pulse shape to be used for the transmitted signal for the
%                   wiener function and the optimal detection
% Outputs:  x_pul    - a vector of the pulse shaped signal of size
%                      k*2*delay
%           x_mod - the vector representing modulated x without errors (use
%                   this for checking the error probability)
%
% (Note): the number of samples of the raised cosine and thereby the signal
% during one period is k*2*delay, for default use k=10, delay =5
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers:   Marcel Nassar (nassar@ece.utexas.edu)


x=randint(1,no_bits);           %generate a random sequence of required bits
x_mod=pammod(x,M);              %modulate them using M-PAM
N=length(y);                    %Get the number of samples
x_mod_ex=x_mod(ones(1,N),:);    %Replicate the obtained bits N times to 
                                %  separate the bits in a way that would
                                %  cancel ISI

x_pul=y(ones(1,no_bits),:);     %replicate the pulse shape
x_pul=x_pul';                   
x_pul=x_pul.*x_mod_ex;          %produce the pulse shaped signal
x_pul=x_pul(:);