function noise_data = RFI_makeScalarNoiseClassA_pdf(pdf_w, x, N)
%
% This function takes a pdf generated from RFI_makeScalarPDFClassA
% and creates the corresponding noise samples.  This function is
% used so we can decouple the pdf generation from the noise sample
% generation leading in much faster computation time.
%
% Inputs:   pdf_w  - pdf coefficients from RFI_makeScalarPDFClassA
%           x      - values corresponding to the weights in pdf_w
%           N      - Number of noise samples to generate

% 
% Outputs:  noise_data - N length vector of noise data generated based on
%                        the Class A Middleton Noise model with the given
%                        parameters
%
%References:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
% [2] D. Middleton, Non-Gaussian noise models in signal processing
%     for telecommunications: New methods and results for Class A and Class B 
%     noise models, IEEE Transactions on Information Theory, vol. 45, no. 4, 
%     pp. 1129-1149, May 1999.
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Marcel Nassar  (nassar@ece.utexas.edu)  
%              Marcus DeYoung (deyoung@ece.utexas.edu)
%
% Revisions:
% v 1.0 gulati -- original RFI_NoiseSamplesClassA
% v 1.1 mrd -- decoupled, changed to use randsample for speed improvement.
%
%
indicies = randsample(length(pdf_w), N, true, pdf_w);
noise_data = x(indicies);

%normalize the samples to have a unit second moment
noise_data=noise_data/sqrt(moment(noise_data,2)); 