function beta = RFI_myriad_res( x,k, resolution )
%beta = RFI_myriad_res( x,k, resolution );
%This function computes the sample myriad of the window x with linearity
%parameter k. The minimization is performed by exhaustively taking values
%between the max value and the min value of x with resolution as spacing.
%
% Inputs:   x                   - the sample window
%           k                   - linearity parameter
%           resolution          - spacing between the considered betas
%
% Outputs:  beta                - sample myriad
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)
%
% References:
% [1] J.R. Gonzalez and G.R. Arce. "Optimality of the myriad in practical
% impulsive-noise enviroments," IEEE Trans. on Signal Processing, vol 49,
% no.2, pp. 438-441, February 2001. 


%Settings
N=length(x);
temp = zeros(N);

x_min = min(x);
x_max = max(x);

%Intialization Steps
beta_min = x_min;
temp = x - x_min;
temp = temp.^2;
temp = temp + k^2;
min_val = prod(temp);

for beta_range = x_min:resolution:x_max
    temp = x - beta_range;
    temp = temp.^2;
    temp = temp + k^2;
    product = prod(temp);
    if (product < min_val)
        beta_min = beta_range;
        min_val = product;
    end;
end;

beta = beta_min;
