function [A_est K_est] = RFI_EstMethodofMoments(env_data)
% [A_est K_est] = RFI_EstMethodofMoments(env_data)
% Estimates the parameters of a Middleton Class A model based on the method
% of moments developed by Middleton in [1]
% Inputs:  env_data - Vector of observed envelope values for the noise data
%                     assumed to follow the Middleton Class A model.
% Outputs: A_est  - Estimate of the impulsive index parameter of the
%                   Middleton Class A model
%          K_est  - Estimate of the parameter K (= impulsive index * Gaussian factor) of the
%                   Middleton Class A model
%
% References:
% [1] D. Middleton, Procedures for determining the properties of the first-order canonical models of Class A and Class B electromagnetic interference,
%     IEEE Transactions on Electromagnetic Compatibility, vol. 21, pp. 190-208, Aug. 1979.
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Arvind Sujeeth (arvind.sujeeth@mail.utexas.edu)
%

% Estimator
m2 = moment (env_data, 2);
m4 = moment (env_data, 4);
m6 = moment (env_data, 6);

% Equation 3.5b, 3.5c and using the fact that K = A * Gamma
% Note that Eq 3.5b is incorrect in [1] and has been correctly implemented
% in this code. 
A_est = 9 * (m4 - 2* m2^2)^3 / (2* (m6 + 12*m2^3 -9*m2*m4)^2);
Gamma_est = 2 * m2 * (m6 + 12*m2^3 -9*m2*m4)/ (3 * (m4 - 2*m2^2)^2) - 1;
K_est = 3*m2*(m4 - 2*m2^2)/(m6 - 9*m4*m2 + 12*m2^3) - 9*(m4 - 2*m2^2)^3/(2*(m6 - 9*m4*m2 + 12 * m2^3)^2);

return;