function bits = RFI_bi_detector_quant( s1 , s2, x, A, Gamma, N_T, partition, codebook, SNR )
%bits = RFI_bi_detector( s1 , s2, x, A, Gamma, N_T );
%This function chooses the most likelihood hypothesis between H1 and H2
%corresponding to s1 and s2, given that the additive noise follows Class A
%Middleton Model.
% Inputs:   A  - overlap index (in general belongs to [10^-2,1])
%           Gamma - ratio of the intensity of the independent Gaussian
%                   component to the intensity of the impulsive non-Gaussian
%                   component (in general belongs to [10^-6,1])
%           N_T  - the number of retained terms of the infinite series
%                  after truncation
%           s1    - vector representing the transmitted signal under hypothesis
%                   H1 (bit 1 in this case)
%           s2    - vector representing the transmitted signal under hypothesis
%                   H2 (bit 0 in this case)
%           x     - matrix representing the received signal (each column represent
%                   a single modulated bit, that is given a i-th column it
%                   represents the i-th bit pulse shaped signal)
%           partition, codeword  - see lloyds for details
% Outputs:  bits       - a vector containing the detected bit stream
%
% Reference:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

s1=s1(:);
s2=s2(:);

[N M]=size(x); % number of samples
% Implementing Eq 15 in [1]
diff_H1 = (x-s1(:,ones(1,M)))/sqrt(10^(-SNR/10)); 
diff_H1=diff_H1(:);
diff_H2 = (x-s2(:,ones(1,M)))/sqrt(10^(-SNR/10));
diff_H2=diff_H2(:);
[index,quant_pdf_H1] = quantiz(RFI_MakePDFClassA(diff_H1,A, Gamma, N_T),partition,codebook);
[index,quant_pdf_H2] = quantiz(RFI_MakePDFClassA( diff_H2,A, Gamma, N_T),partition,codebook);
quant_pdf_H1=reshape(quant_pdf_H1,N,M);
quant_pdf_H2=reshape(quant_pdf_H2,N,M);
prob_H1 = prod(quant_pdf_H1);
prob_H2 = prod(quant_pdf_H2);
[c sign_index] = max(abs(s1)); %obtain the index of the maximum magnitude of the raised cosine
                               % this maximum indicates the sign of the
                               % waveform s1, s2 has the same index
bits = (prob_H1 > prob_H2)*sign(s1(sign_index)) + (prob_H1 <= prob_H2)*sign(s2(sign_index)); %detect the bits