function [noise_data] = RFI_MakeDataAlphaStable(alpha, disper, delta, N)
% [noise_data] = RFI_MakeDataAlphaStable(alpha, disper, delta, N);
% This function generates a vector of synthetic data samples that follow the symmetric alpha
% stable model.
% Inputs:   alpha  - Characteristic Exponent
%           disper - Dispersion Parameter
%           delta  - Localization Parameter
%           N      - No of samples to be generated
% Outputs:  noise_data - N length vector of noise data generated based on
%                        symmetric alpha stable model
%
% Reference:
% Ercan Kuruoglu, "Signal Processing in alpha-stable noise environments - A
% least lp-NORM approach", PhD Thesis, University of Cambridge, Nov 1998.
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 09/22/07  1.0         gulati    Initial Creation
% 11/14/07  1.1 Beta    gulati    Fixed the fact that S((alpha,disper,0) 
%                                 = disper ^ (1/alpha)* S(alpha, 1, 0) in
%                                 the implementation. Now sync with [1].

clear j;

% Refer to [1] for details on this method of data generation.
if (alpha == 2)         % Gaussian
    noise_data = sqrt(2)*randn(1,N);
elseif (alpha == 1)     % Cauchy
    noise_data = tan(pi*(rand(1,N)-.5*ones(1,N)));
else
    u = pi*(rand(1,N)-.5*ones(1,N));
    noise_data = (sin (alpha.*u)) ./ ((cos(u)).^(1/alpha)) .* ((cos((1-alpha).*u)) ./ (-log (rand(1,N)))).^((1-alpha)/alpha);
end
%
noise_data = (disper)^(1/alpha) .* noise_data + delta;      % Including dispersion and localization

return