function [x_pul x_mod Fstatus] = RFI_getANDmodFDATA( fid, no_RDbytes, precision,NObits_pres, M, y )
%[x_pul x_mod] = RFI_getDATA( fid, no_RDbytes, precision )
%   Reads bits from a file and modulates them for channel transmission.
% Inputs:   fid   - the id of the open file that will serve as the source
%                   of the bits
%           no_RDbytes   - number of elements of size corresponding to the
%                   given precision (usually considered bytes)
%           precision  - specifies the precision used to read from the
%                  source file (use 'uint8' to ensure there are no issues at the end of the file)
%           NObits_pres - the number of bits used to represent variable saved with the given precision (8 for uint8) 
%           M - the number of constellation point, use 2
%           y     - pulse shape to be used for the transmitted signal 
% Outputs:  x_pul    - a vector of the pulse shaped signal of size
%                      k*2*delay
%           x_mod - the vector representing modulated x without errors (use
%                   this for checking the error probability)
%           Fstatus - an indicator which is set to 1 if the file still has
%           data otherwise it set to -1
%
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar (nassar@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 02/6/09    1.0        nassar    Original implementation 


RDdata = fread(fid, no_RDbytes, ['*' precision]);

if (feof(fid)==1)
    Fstatus = -1; %to represent that the file has reached its end
    x_pul = [];
    x_mod = [];
    return;
else
    Fstatus = 1; %to represent that the file still has data
end;

binary = dec2bin(RDdata,NObits_pres);
data = uint8(binary(:))-48; % 8bit integer cast minus number representation
%data = str2num(binary(:));  % String implementation slow

x_mod = pammod(data',M);
N=length(y);                    %Get the number of samples
x_mod_ex=x_mod(ones(1,N),:);    %Replicate the obtained bits N times to 
                                %  separate the bits in a way that would
                                %  cancel ISI
x_pul=y(ones(1,length(data)),:);     %replicate the pulse shape
x_pul=x_pul';                   
x_pul=x_pul.*x_mod_ex;          %produce the pulse shaped signal
x_pul=x_pul(:);